/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NamedContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpResponse;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.internal.SSLUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Serialization;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.URLUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIDConnectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIDConnectionUtils.class);
    public static final String EMPTY = "";
    public static final String ID_TOKEN_KUBECONFIG = "id-token";
    public static final String ISSUER_KUBECONFIG = "idp-issuer-url";
    public static final String REFRESH_TOKEN_KUBECONFIG = "refresh-token";
    public static final String REFRESH_TOKEN_PARAM = "refresh_token";
    public static final String GRANT_TYPE_PARAM = "grant_type";
    public static final String CLIENT_ID_PARAM = "client_id";
    public static final String CLIENT_SECRET_PARAM = "client_secret";
    public static final String ID_TOKEN_PARAM = "id_token";
    public static final String ACCESS_TOKEN_PARAM = "access_token";
    public static final String CLIENT_ID_KUBECONFIG = "client-id";
    public static final String CLIENT_SECRET_KUBECONFIG = "client-secret";
    public static final String IDP_CERT_DATA = "idp-certificate-authority-data";
    public static final String TOKEN_ENDPOINT_PARAM = "token_endpoint";
    public static final String WELL_KNOWN_OPENID_CONFIGURATION = ".well-known/openid-configuration";
    public static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";

    private OpenIDConnectionUtils() {
    }

    public static String resolveOIDCTokenFromAuthConfig(Map<String, String> currentAuthProviderConfig, HttpClient.Builder clientBuilder) {
        String accessToken = currentAuthProviderConfig.get(ID_TOKEN_KUBECONFIG);
        String issuer = currentAuthProviderConfig.get(ISSUER_KUBECONFIG);
        String clientId = currentAuthProviderConfig.get(CLIENT_ID_KUBECONFIG);
        String refreshToken = currentAuthProviderConfig.get(REFRESH_TOKEN_KUBECONFIG);
        String clientSecret = currentAuthProviderConfig.getOrDefault(CLIENT_SECRET_KUBECONFIG, EMPTY);
        String idpCert = currentAuthProviderConfig.get(IDP_CERT_DATA);
        if (OpenIDConnectionUtils.isTokenRefreshSupported(currentAuthProviderConfig)) {
            return OpenIDConnectionUtils.getOIDCProviderTokenEndpointAndRefreshToken(issuer, clientId, refreshToken, clientSecret, accessToken, idpCert, clientBuilder);
        }
        return accessToken;
    }

    static String getOIDCProviderTokenEndpointAndRefreshToken(HttpClient client, Map<String, Object> wellKnownOpenIdConfiguration, String clientId, String refreshToken, String clientSecret, String accessToken, boolean shouldPersistUpdatedTokenInKubeConfig) {
        String oidcTokenEndpoint = OpenIDConnectionUtils.getParametersFromDiscoveryResponse(wellKnownOpenIdConfiguration, TOKEN_ENDPOINT_PARAM);
        try {
            String freshAccessToken = OpenIDConnectionUtils.refreshToken(client, oidcTokenEndpoint, clientId, refreshToken, clientSecret, shouldPersistUpdatedTokenInKubeConfig);
            if (freshAccessToken != null) {
                accessToken = freshAccessToken;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not refresh OIDC token: {}", (Object)e.getMessage());
        }
        return accessToken;
    }

    static boolean isTokenRefreshSupported(Map<String, String> currentAuthProviderConfig) {
        return Utils.isNotNull(currentAuthProviderConfig.get(REFRESH_TOKEN_KUBECONFIG));
    }

    static String refreshToken(HttpClient client, String oidcTokenEndpoint, String clientId, String refreshToken, String clientSecret, boolean shouldPersistUpdatedTokenInKubeConfig) {
        try {
            Map<String, Object> response = OpenIDConnectionUtils.refreshOidcToken(client, clientId, refreshToken, clientSecret, oidcTokenEndpoint);
            if (!response.containsKey(ID_TOKEN_PARAM)) {
                LOGGER.warn("token response did not contain an id_token, either the scope \\\"openid\\\" wasn't requested upon login, or the provider doesn't support id_tokens as part of the refresh response.");
                return null;
            }
            if (shouldPersistUpdatedTokenInKubeConfig && !OpenIDConnectionUtils.persistKubeConfigWithUpdatedToken(response)) {
                LOGGER.warn("oidc: failure while persisting new tokens into KUBECONFIG");
            }
            return String.valueOf(response.get(ID_TOKEN_PARAM));
        }
        catch (IOException e) {
            LOGGER.warn("Failure in fetching refresh token: ", (Throwable)e);
            return null;
        }
    }

    static Map<String, Object> refreshOidcToken(HttpClient client, String clientId, String refreshToken, String clientSecret, String tokenURL) throws IOException {
        HttpRequest request = OpenIDConnectionUtils.getTokenRefreshHttpRequest(client, tokenURL, clientId, refreshToken, clientSecret);
        HttpResponse<String> response = client.send(request, String.class);
        String body = response.body();
        if (body != null) {
            if (response.isSuccessful()) {
                return OpenIDConnectionUtils.convertJsonStringToMap(body);
            }
            LOGGER.warn("Response: {}", (Object)body);
        }
        return Collections.emptyMap();
    }

    static Map<String, Object> getOIDCDiscoveryDocumentAsMap(HttpClient client, String issuer) {
        HttpRequest request = client.newHttpRequestBuilder().uri(OpenIDConnectionUtils.getWellKnownUrlForOpenIDIssuer(issuer)).build();
        try {
            HttpResponse<String> response = client.send(request, String.class);
            if (response.isSuccessful() && response.body() != null) {
                return OpenIDConnectionUtils.convertJsonStringToMap(response.body());
            }
            String responseBody = response.body();
            LOGGER.warn("oidc: failed to query metadata endpoint: {} {}", (Object)response.code(), (Object)responseBody);
        }
        catch (IOException e) {
            LOGGER.warn("Could not refresh OIDC token, failure in getting refresh URL", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    static String getWellKnownUrlForOpenIDIssuer(String issuer) {
        return URLUtils.join(issuer, "/", WELL_KNOWN_OPENID_CONFIGURATION);
    }

    static String getParametersFromDiscoveryResponse(Map<String, Object> responseAsJson, String key) {
        if (responseAsJson.containsKey(key)) {
            return String.valueOf(responseAsJson.get(key));
        }
        LOGGER.warn("oidc: oidc: discovery object doesn't contain a {}", (Object)key);
        return EMPTY;
    }

    static boolean persistKubeConfigWithUpdatedToken(String kubeConfigPath, Map<String, Object> updatedAuthProviderConfig) throws IOException {
        org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Config config = KubeConfigUtils.parseConfig(new File(kubeConfigPath));
        NamedContext currentNamedContext = KubeConfigUtils.getCurrentContext(config);
        if (currentNamedContext != null) {
            int currentUserIndex = KubeConfigUtils.getNamedUserIndexFromConfig(config, currentNamedContext.getContext().getUser());
            Map<String, String> authProviderConfig = config.getUsers().get(currentUserIndex).getUser().getAuthProvider().getConfig();
            authProviderConfig.put(ID_TOKEN_KUBECONFIG, String.valueOf(updatedAuthProviderConfig.get(ID_TOKEN_PARAM)));
            authProviderConfig.put(REFRESH_TOKEN_KUBECONFIG, String.valueOf(updatedAuthProviderConfig.get("refresh_token")));
            config.getUsers().get(currentUserIndex).getUser().getAuthProvider().setConfig(authProviderConfig);
            try {
                KubeConfigUtils.persistKubeConfigIntoFile(config, kubeConfigPath);
                return true;
            }
            catch (IOException exception) {
                LOGGER.warn("failed to write file {}", (Object)kubeConfigPath, (Object)exception);
            }
        }
        return false;
    }

    private static Map<String, Object> convertJsonStringToMap(String jsonString) throws JsonProcessingException {
        return Serialization.jsonMapper().readValue(jsonString, Map.class);
    }

    private static HttpClient getDefaultHttpClientWithPemCert(String idpCert, HttpClient.Builder clientBuilder) {
        SSLContext sslContext = null;
        TrustManager[] trustManagers = null;
        String pemCert = new String(Base64.getDecoder().decode(idpCert));
        try {
            trustManagers = SSLUtils.trustManagers(pemCert, null, false, null, null);
            KeyManager[] keyManagers = SSLUtils.keyManagers(pemCert, null, null, null, null, null, null, null);
            sslContext = SSLUtils.sslContext(keyManagers, trustManagers);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new RuntimeException("Could not import idp certificate", e);
        }
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext, trustManagers);
        }
        return clientBuilder.build();
    }

    private static HttpRequest getTokenRefreshHttpRequest(HttpClient client, String tokenEndpointUrl, String clientId, String refreshToken, String clientSecret) {
        HttpRequest.Builder httpRequestBuilder = client.newHttpRequestBuilder().uri(tokenEndpointUrl);
        Map<String, String> requestBody = OpenIDConnectionUtils.getRequestBodyContentForRefresh(clientId, refreshToken, clientSecret);
        String credentials = Base64.getEncoder().encodeToString((clientId + ':' + clientSecret).getBytes(StandardCharsets.UTF_8));
        httpRequestBuilder.header("Authorization", "Basic " + credentials);
        httpRequestBuilder.post(requestBody);
        return httpRequestBuilder.build();
    }

    private static Map<String, String> getRequestBodyContentForRefresh(String clientId, String refreshToken, String clientSecret) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("refresh_token", refreshToken);
        result.put(GRANT_TYPE_PARAM, "refresh_token");
        result.put(CLIENT_ID_PARAM, clientId);
        result.put(CLIENT_SECRET_PARAM, clientSecret);
        return result;
    }

    private static String getOIDCProviderTokenEndpointAndRefreshToken(String issuer, String clientId, String refreshToken, String clientSecret, String accessToken, String idpCert, HttpClient.Builder clientBuilder) {
        try (HttpClient newClient = OpenIDConnectionUtils.getDefaultHttpClientWithPemCert(idpCert, clientBuilder);){
            Map<String, Object> wellKnownOpenIdConfiguration = OpenIDConnectionUtils.getOIDCDiscoveryDocumentAsMap(newClient, issuer);
            String string = OpenIDConnectionUtils.getOIDCProviderTokenEndpointAndRefreshToken(newClient, wellKnownOpenIdConfiguration, clientId, refreshToken, clientSecret, accessToken, true);
            return string;
        }
    }

    private static boolean persistKubeConfigWithUpdatedToken(Map<String, Object> updatedAuthProviderConfig) throws IOException {
        return OpenIDConnectionUtils.persistKubeConfigWithUpdatedToken(Config.getKubeconfigFilename(), updatedAuthProviderConfig);
    }
}

