/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils;

import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.OwnerReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Gettable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.LogWatch;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PodResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.base.OperationContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodOperationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PodOperationUtil.class);

    private PodOperationUtil() {
    }

    public static List<PodResource<Pod>> getFilteredPodsForLogs(PodOperationsImpl podOperations, PodList controllerPodList, String controllerUid) {
        ArrayList<PodResource<Pod>> pods = new ArrayList<PodResource<Pod>>();
        for (Pod pod : controllerPodList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid(pod);
            if (ownerReference == null || !ownerReference.getUid().equals(controllerUid)) continue;
            pods.add((PodResource<Pod>)podOperations.withName(pod.getMetadata().getName()));
        }
        return pods;
    }

    public static PodOperationsImpl getGenericPodOperations(OperationContext context, boolean isPretty, Integer podLogWaitTimeout, String containerId) {
        return new PodOperationsImpl(new PodOperationContext(containerId, null, null, null, null, null, null, null, null, false, false, false, null, null, null, isPretty, null, null, null, null, null, podLogWaitTimeout), context.withName(null).withApiGroupName(null).withApiGroupVersion("v1"));
    }

    public static List<PodResource<Pod>> getPodOperationsForController(OperationContext context, String controllerUid, Map<String, String> selectorLabels, boolean isPretty, Integer podLogWaitTimeout, String containerId) {
        return PodOperationUtil.getPodOperationsForController(PodOperationUtil.getGenericPodOperations(context, isPretty, podLogWaitTimeout, containerId), controllerUid, selectorLabels);
    }

    public static LogWatch watchLog(List<PodResource<Pod>> podResources, OutputStream out) {
        if (!podResources.isEmpty()) {
            if (podResources.size() > 1) {
                LOG.debug("Found {} pods, Using first one to watch logs", (Object)podResources.size());
            }
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }

    public static Reader getLogReader(List<PodResource<Pod>> podResources) {
        if (!podResources.isEmpty()) {
            if (podResources.size() > 1) {
                LOG.debug("Found {} pods, Using first one to get log reader", (Object)podResources.size());
            }
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    public static String getLog(List<PodResource<Pod>> podOperationList, Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PodResource<Pod> podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    static List<PodResource<Pod>> getPodOperationsForController(PodOperationsImpl podOperations, String controllerUid, Map<String, String> selectorLabels) {
        PodList controllerPodList = (PodList)podOperations.withLabels((Map)selectorLabels).list();
        return PodOperationUtil.getFilteredPodsForLogs(podOperations, controllerPodList, controllerUid);
    }

    public static void waitUntilReadyBeforeFetchingLogs(PodResource<Pod> podOperation, Integer logWaitTimeout) {
        try {
            Pod pod = (Pod)((Gettable)podOperation.fromServer()).get();
            if (pod != null && pod.getStatus() != null && pod.getStatus().getPhase().equals("Pending")) {
                podOperation.waitUntilReady(logWaitTimeout.intValue(), TimeUnit.SECONDS);
            }
        }
        catch (Exception otherException) {
            LOG.debug("Error while waiting for Pod to become Ready: {}", (Object)otherException.getMessage());
        }
    }
}

