/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.maprfs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.runtime.fs.maprfs.MapRFileSystem;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRFsFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MapRFsFactory.class);

    public String getScheme() {
        return "maprfs";
    }

    public FileSystem create(URI fsUri) throws IOException {
        Preconditions.checkNotNull((Object)fsUri, (String)"fsUri");
        try {
            LOG.info("Trying to load and instantiate MapR File System");
            return new MapRFileSystem(fsUri);
        }
        catch (LinkageError e) {
            throw new IOException("Could not load MapR file system. Please make sure the Flink runtime classes are part of the classpath or dependencies.", e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Could not instantiate MapR file system.", t);
        }
    }
}

