/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.ganglia;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.dropwizard.ScheduledDropwizardReporter;
import org.apache.flink.metrics.MetricConfig;

@PublicEvolving
public class GangliaReporter
extends ScheduledDropwizardReporter {
    public static final String ARG_DMAX = "dmax";
    public static final String ARG_TMAX = "tmax";
    public static final String ARG_TTL = "ttl";
    public static final String ARG_MODE_ADDRESSING = "addressingMode";

    public ScheduledReporter getReporter(MetricConfig config) {
        try {
            String host = config.getString("host", null);
            int port = config.getInteger("port", -1);
            if (host == null || host.length() == 0 || port < 1) {
                throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
            }
            String addressingMode = config.getString(ARG_MODE_ADDRESSING, "MULTICAST");
            int ttl = config.getInteger(ARG_TTL, 1);
            GMetric gMetric = new GMetric(host, port, GMetric.UDPAddressingMode.valueOf((String)addressingMode), ttl);
            String prefix = config.getString("prefix", null);
            String conversionRate = config.getString("rateConversion", null);
            String conversionDuration = config.getString("durationConversion", null);
            int dMax = config.getInteger(ARG_DMAX, 0);
            int tMax = config.getInteger(ARG_TMAX, 60);
            GangliaReporter.Builder builder = com.codahale.metrics.ganglia.GangliaReporter.forRegistry((MetricRegistry)this.registry);
            if (prefix != null) {
                builder.prefixedWith(prefix);
            }
            if (conversionRate != null) {
                builder.convertRatesTo(TimeUnit.valueOf(conversionRate));
            }
            if (conversionDuration != null) {
                builder.convertDurationsTo(TimeUnit.valueOf(conversionDuration));
            }
            builder.withDMax(dMax);
            builder.withTMax(tMax);
            this.log.info("Configured GangliaReporter with {host:{}, port:{}, dmax:{}, tmax:{}, ttl:{}, addressingMode:{}}", new Object[]{host, port, dMax, tMax, ttl, addressingMode});
            return builder.build(gMetric);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while instantiating GangliaReporter.", e);
        }
    }
}

