/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.prometheus;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.runtime.metrics.groups.FrontMetricGroup;
import org.apache.flink.shaded.io.prometheus.client.Collector;
import org.apache.flink.shaded.io.prometheus.client.CollectorRegistry;
import org.apache.flink.shaded.io.prometheus.client.Gauge;
import org.apache.flink.shaded.io.prometheus.client.exporter.HTTPServer;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class PrometheusReporter
implements MetricReporter {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusReporter.class);
    static final String ARG_PORT = "port";
    private static final String DEFAULT_PORT = "9249";
    private static final Pattern UNALLOWED_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9:_]");
    private static final CharacterFilter CHARACTER_FILTER = new CharacterFilter(){

        public String filterCharacters(String input) {
            return PrometheusReporter.replaceInvalidChars(input);
        }
    };
    private static final char SCOPE_SEPARATOR = '_';
    private static final String SCOPE_PREFIX = "flink_";
    private HTTPServer httpServer;
    private int port;
    private final Map<String, AbstractMap.SimpleImmutableEntry<Collector, Integer>> collectorsWithCountByMetricName = new HashMap<String, AbstractMap.SimpleImmutableEntry<Collector, Integer>>();

    @VisibleForTesting
    int getPort() {
        Preconditions.checkState((this.httpServer != null ? 1 : 0) != 0, (Object)"Server has not been initialized.");
        return this.port;
    }

    @VisibleForTesting
    static String replaceInvalidChars(String input) {
        return UNALLOWED_CHAR_PATTERN.matcher(input).replaceAll("_");
    }

    public void open(MetricConfig config) {
        String portsConfig = config.getString(ARG_PORT, DEFAULT_PORT);
        Iterator ports = NetUtils.getPortRangeFromString((String)portsConfig);
        while (ports.hasNext()) {
            int port = (Integer)ports.next();
            try {
                this.httpServer = new HTTPServer(port);
                this.port = port;
                LOG.info("Started PrometheusReporter HTTP server on port {}.", (Object)port);
                break;
            }
            catch (IOException ioe) {
                LOG.debug("Could not start PrometheusReporter HTTP server on port {}.", (Object)port, (Object)ioe);
            }
        }
        if (this.httpServer == null) {
            throw new RuntimeException("Could not start PrometheusReporter HTTP server on any configured port. Ports: " + portsConfig);
        }
    }

    public void close() {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        CollectorRegistry.defaultRegistry.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        LinkedList<String> dimensionKeys = new LinkedList<String>();
        LinkedList<String> dimensionValues = new LinkedList<String>();
        for (Map.Entry dimension : group.getAllVariables().entrySet()) {
            String key = (String)dimension.getKey();
            dimensionKeys.add(CHARACTER_FILTER.filterCharacters(key.substring(1, key.length() - 1)));
            dimensionValues.add(CHARACTER_FILTER.filterCharacters((String)dimension.getValue()));
        }
        String scopedMetricName = PrometheusReporter.getScopedName(metricName, group);
        String helpString = metricName + " (scope: " + PrometheusReporter.getLogicalScope(group) + ")";
        Integer count = 0;
        PrometheusReporter prometheusReporter = this;
        synchronized (prometheusReporter) {
            Collector collector;
            if (this.collectorsWithCountByMetricName.containsKey(scopedMetricName)) {
                AbstractMap.SimpleImmutableEntry<Collector, Integer> collectorWithCount = this.collectorsWithCountByMetricName.get(scopedMetricName);
                collector = collectorWithCount.getKey();
                count = collectorWithCount.getValue();
            } else {
                collector = PrometheusReporter.createCollector(metric, dimensionKeys, dimensionValues, scopedMetricName, helpString);
                try {
                    collector.register();
                }
                catch (Exception e) {
                    LOG.warn("There was a problem registering metric {}.", (Object)metricName, (Object)e);
                }
            }
            PrometheusReporter.addMetric(metric, dimensionValues, collector);
            this.collectorsWithCountByMetricName.put(scopedMetricName, new AbstractMap.SimpleImmutableEntry<Collector, Integer>(collector, count + 1));
        }
    }

    private static String getScopedName(String metricName, MetricGroup group) {
        return SCOPE_PREFIX + PrometheusReporter.getLogicalScope(group) + '_' + CHARACTER_FILTER.filterCharacters(metricName);
    }

    private static Collector createCollector(Metric metric, List<String> dimensionKeys, List<String> dimensionValues, String scopedMetricName, String helpString) {
        Collector collector;
        if (metric instanceof Gauge || metric instanceof Counter || metric instanceof Meter) {
            collector = ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)org.apache.flink.shaded.io.prometheus.client.Gauge.build().name(scopedMetricName)).help(helpString)).labelNames(PrometheusReporter.toArray(dimensionKeys))).create();
        } else if (metric instanceof Histogram) {
            collector = new HistogramSummaryProxy((Histogram)metric, scopedMetricName, helpString, dimensionKeys, dimensionValues);
        } else {
            LOG.warn("Cannot create collector for unknown metric type: {}. This indicates that the metric type is not supported by this reporter.", (Object)metric.getClass().getName());
            collector = null;
        }
        return collector;
    }

    private static void addMetric(Metric metric, List<String> dimensionValues, Collector collector) {
        if (metric instanceof Gauge) {
            ((org.apache.flink.shaded.io.prometheus.client.Gauge)collector).setChild(PrometheusReporter.gaugeFrom((Gauge)metric), PrometheusReporter.toArray(dimensionValues));
        } else if (metric instanceof Counter) {
            ((org.apache.flink.shaded.io.prometheus.client.Gauge)collector).setChild(PrometheusReporter.gaugeFrom((Counter)metric), PrometheusReporter.toArray(dimensionValues));
        } else if (metric instanceof Meter) {
            ((org.apache.flink.shaded.io.prometheus.client.Gauge)collector).setChild(PrometheusReporter.gaugeFrom((Meter)metric), PrometheusReporter.toArray(dimensionValues));
        } else if (metric instanceof Histogram) {
            ((HistogramSummaryProxy)collector).addChild((Histogram)metric, dimensionValues);
        } else {
            LOG.warn("Cannot add unknown metric type: {}. This indicates that the metric type is not supported by this reporter.", (Object)metric.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        String scopedMetricName = PrometheusReporter.getScopedName(metricName, group);
        PrometheusReporter prometheusReporter = this;
        synchronized (prometheusReporter) {
            AbstractMap.SimpleImmutableEntry<Collector, Integer> collectorWithCount = this.collectorsWithCountByMetricName.get(scopedMetricName);
            Integer count = collectorWithCount.getValue();
            Collector collector = collectorWithCount.getKey();
            if (count == 1) {
                try {
                    CollectorRegistry.defaultRegistry.unregister(collector);
                }
                catch (Exception e) {
                    LOG.warn("There was a problem unregistering metric {}.", (Object)scopedMetricName, (Object)e);
                }
                this.collectorsWithCountByMetricName.remove(scopedMetricName);
            } else {
                this.collectorsWithCountByMetricName.put(scopedMetricName, new AbstractMap.SimpleImmutableEntry<Collector, Integer>(collector, count - 1));
            }
        }
    }

    private static String getLogicalScope(MetricGroup group) {
        return ((FrontMetricGroup)group).getLogicalScope(CHARACTER_FILTER, '_');
    }

    @VisibleForTesting
    static Gauge.Child gaugeFrom(final Gauge gauge) {
        return new Gauge.Child(){

            @Override
            public double get() {
                Object value = gauge.getValue();
                if (value == null) {
                    LOG.debug("Gauge {} is null-valued, defaulting to 0.", (Object)gauge);
                    return 0.0;
                }
                if (value instanceof Double) {
                    return (Double)value;
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1.0 : 0.0;
                }
                LOG.debug("Invalid type for Gauge {}: {}, only number types and booleans are supported by this reporter.", (Object)gauge, (Object)value.getClass().getName());
                return 0.0;
            }
        };
    }

    private static Gauge.Child gaugeFrom(final Counter counter) {
        return new Gauge.Child(){

            @Override
            public double get() {
                return counter.getCount();
            }
        };
    }

    private static Gauge.Child gaugeFrom(final Meter meter) {
        return new Gauge.Child(){

            @Override
            public double get() {
                return meter.getRate();
            }
        };
    }

    private static List<String> addToList(List<String> list, String element) {
        ArrayList<String> result = new ArrayList<String>(list);
        result.add(element);
        return result;
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    @VisibleForTesting
    static class HistogramSummaryProxy
    extends Collector {
        static final List<Double> QUANTILES = Arrays.asList(0.5, 0.75, 0.95, 0.98, 0.99, 0.999);
        private final String metricName;
        private final String helpString;
        private final List<String> labelNamesWithQuantile;
        private final Map<List<String>, Histogram> histogramsByLabelValues = new HashMap<List<String>, Histogram>();

        HistogramSummaryProxy(Histogram histogram, String metricName, String helpString, List<String> labelNames, List<String> labelValues) {
            this.metricName = metricName;
            this.helpString = helpString;
            this.labelNamesWithQuantile = PrometheusReporter.addToList(labelNames, "quantile");
            this.histogramsByLabelValues.put(labelValues, histogram);
        }

        @Override
        public List<Collector.MetricFamilySamples> collect() {
            LinkedList<Collector.MetricFamilySamples.Sample> samples = new LinkedList<Collector.MetricFamilySamples.Sample>();
            for (Map.Entry<List<String>, Histogram> labelValuesToHistogram : this.histogramsByLabelValues.entrySet()) {
                this.addSamples(labelValuesToHistogram.getKey(), labelValuesToHistogram.getValue(), samples);
            }
            return Collections.singletonList(new Collector.MetricFamilySamples(this.metricName, Collector.Type.SUMMARY, this.helpString, samples));
        }

        void addChild(Histogram histogram, List<String> labelValues) {
            this.histogramsByLabelValues.put(labelValues, histogram);
        }

        private void addSamples(List<String> labelValues, Histogram histogram, List<Collector.MetricFamilySamples.Sample> samples) {
            samples.add(new Collector.MetricFamilySamples.Sample(this.metricName + "_count", this.labelNamesWithQuantile.subList(0, this.labelNamesWithQuantile.size() - 1), labelValues, histogram.getCount()));
            for (Double quantile : QUANTILES) {
                samples.add(new Collector.MetricFamilySamples.Sample(this.metricName, this.labelNamesWithQuantile, PrometheusReporter.addToList(labelValues, quantile.toString()), histogram.getStatistics().getQuantile(quantile.doubleValue())));
            }
        }
    }
}

