/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CustomSessionCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.DefaultCredentialProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.EnvironmentVariableCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.InstanceProfileCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.STSAssumeRoleSessionCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.STSKeyPairSessionCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.SystemPropertiesCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.BasicCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.KeyPairCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.profile.DefaultProfile;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.profile.IClientProfile;

public class CredentialsProviderFactory {
    public static DefaultCredentialProvider newDefaultCredentialProvider(String accessKeyId, String secretAccessKey) {
        return new DefaultCredentialProvider(accessKeyId, secretAccessKey);
    }

    public DefaultCredentialProvider newDefaultCredentialProvider(String accessKeyId, String secretAccessKey, String securityToken) {
        return new DefaultCredentialProvider(accessKeyId, secretAccessKey, securityToken);
    }

    public static EnvironmentVariableCredentialsProvider newEnvironmentVariableCredentialsProvider() throws ClientException {
        return new EnvironmentVariableCredentialsProvider();
    }

    public static SystemPropertiesCredentialsProvider newSystemPropertiesCredentialsProvider() throws ClientException {
        return new SystemPropertiesCredentialsProvider();
    }

    public static STSAssumeRoleSessionCredentialsProvider newSTSAssumeRoleSessionCredentialsProvider(String regionId, String accessKeyId, String accessKeySecret, String roleArn) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile(regionId);
        BasicCredentials basicCredentials = new BasicCredentials(accessKeyId, accessKeySecret);
        return new STSAssumeRoleSessionCredentialsProvider(basicCredentials, roleArn, (IClientProfile)profile);
    }

    public static InstanceProfileCredentialsProvider newInstanceProfileCredentialsProvider(String roleName) throws ClientException {
        return new InstanceProfileCredentialsProvider(roleName);
    }

    public static STSKeyPairSessionCredentialsProvider newSTSKeyPairSessionCredentialsProvider(String regionId, String publicKeyId, String privateKey) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile(regionId);
        KeyPairCredentials keyPairCredentials = new KeyPairCredentials(publicKeyId, privateKey);
        return new STSKeyPairSessionCredentialsProvider(keyPairCredentials, profile);
    }

    public static CustomSessionCredentialsProvider newCustomSessionCredentialsProvider(String ossAuthServerHost) throws ClientException {
        return new CustomSessionCredentialsProvider(ossAuthServerHost);
    }
}

