/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import java.io.IOException;
import java.net.URL;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CredentialsFetcher;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.HttpRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.HttpResponse;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.MethodType;

public abstract class HttpCredentialsFetcher
implements CredentialsFetcher {
    @Override
    public abstract URL buildUrl() throws ClientException;

    @Override
    public abstract Credentials parse(HttpResponse var1) throws ClientException;

    @Override
    public Credentials fetch() throws ClientException {
        URL url = this.buildUrl();
        HttpRequest request = new HttpRequest(url.toString());
        request.setMethod(MethodType.GET);
        request.setConnectTimeout(5000);
        request.setReadTimeout(5000);
        HttpResponse response = null;
        try {
            response = this.send(request);
        }
        catch (IOException e) {
            throw new ClientException("CredentialsFetcher.fetch exception: " + e);
        }
        return this.parse(response);
    }

    @Override
    public HttpResponse send(HttpRequest request) throws IOException {
        HttpResponse response = HttpResponse.getResponse(request);
        if (response.getStatus() != 200) {
            throw new IOException("HttpCode=" + response.getStatus());
        }
        return response;
    }

    @Override
    public Credentials fetch(int retryTimes) throws ClientException {
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                return this.fetch();
            }
            catch (ClientException e) {
                if (i != retryTimes) continue;
                throw e;
            }
        }
        throw new ClientException("Failed to connect ECS Metadata Service: Max retry times exceeded.");
    }
}

