/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyuncs;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.AcsResponse;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.AcsURLEncoder;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.AlibabaCloudCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.Credential;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.ISignatureComposer;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.LegacyCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.Signer;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.FormatType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.HttpRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.ProtocolType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.ProductDomain;

public abstract class AcsRequest<T extends AcsResponse>
extends HttpRequest {
    private String version = null;
    private String product = null;
    private String actionName = null;
    private String regionId = null;
    private String securityToken = null;
    private FormatType acceptFormat = null;
    protected ISignatureComposer composer = null;
    private ProtocolType protocol = ProtocolType.HTTP;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> domainParameters = new HashMap<String, String>();
    private final Map<String, String> bodyParameters = new HashMap<String, String>();
    private String locationProduct;
    private String endpointType;

    public AcsRequest(String product) {
        super(null);
        this.headers.put("x-sdk-client", "Java/2.0.0");
        this.product = product;
    }

    public AcsRequest(String product, String version) {
        super(null);
        this.product = product;
        this.setVersion(version);
    }

    public String getLocationProduct() {
        return this.locationProduct;
    }

    public void setLocationProduct(String locationProduct) {
        this.locationProduct = locationProduct;
        this.putQueryParameter("ServiceCode", locationProduct);
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
        this.putQueryParameter("Type", endpointType);
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getProduct() {
        return this.product;
    }

    public ProtocolType getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolType protocol) {
        this.protocol = protocol;
    }

    public Map<String, String> getQueryParameters() {
        return Collections.unmodifiableMap(this.queryParameters);
    }

    public <K> void putQueryParameter(String name, K value) {
        this.setParameter(this.queryParameters, name, value);
    }

    protected void putQueryParameter(String name, String value) {
        this.setParameter(this.queryParameters, name, value);
    }

    public Map<String, String> getDomainParameters() {
        return Collections.unmodifiableMap(this.domainParameters);
    }

    protected void putDomainParameter(String name, Object value) {
        this.setParameter(this.domainParameters, name, value);
    }

    public Map<String, String> getBodyParameters() {
        return Collections.unmodifiableMap(this.bodyParameters);
    }

    protected void putDomainParameter(String name, String value) {
        this.setParameter(this.domainParameters, name, value);
    }

    protected void putBodyParameter(String name, Object value) {
        this.setParameter(this.bodyParameters, name, value);
    }

    protected void setParameter(Map<String, String> map, String name, Object value) {
        if (null == map || null == name || null == value) {
            return;
        }
        map.put(name, String.valueOf(value));
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public FormatType getAcceptFormat() {
        return this.acceptFormat;
    }

    public void setAcceptFormat(FormatType acceptFormat) {
        this.acceptFormat = acceptFormat;
        this.putHeaderParameter("Accept", FormatType.mapFormatToAccept(acceptFormat));
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        this.putQueryParameter("SecurityToken", securityToken);
    }

    public static String concatQueryString(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (null == parameters) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder("");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            urlBuilder.append(AcsURLEncoder.encode(key));
            if (val != null) {
                urlBuilder.append("=").append(AcsURLEncoder.encode(val));
            }
            urlBuilder.append("&");
        }
        int strIndex = urlBuilder.length();
        if (parameters.size() > 0) {
            urlBuilder.deleteCharAt(strIndex - 1);
        }
        return urlBuilder.toString();
    }

    public HttpRequest signRequest(Signer signer, Credential credential, FormatType format, ProductDomain domain) throws InvalidKeyException, IllegalStateException, UnsupportedEncodingException, NoSuchAlgorithmException {
        return this.signRequest(signer, new LegacyCredentials(credential), format, domain);
    }

    public abstract HttpRequest signRequest(Signer var1, AlibabaCloudCredentials var2, FormatType var3, ProductDomain var4) throws InvalidKeyException, IllegalStateException, UnsupportedEncodingException, NoSuchAlgorithmException;

    public abstract String composeUrl(String var1, Map<String, String> var2) throws UnsupportedEncodingException;

    public abstract Class<T> getResponseClass();
}

