/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.spec.SecretKeySpec;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.ProviderUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JavaKeyStoreProvider
extends KeyProvider {
    private static final String KEY_METADATA = "KeyMetadata";
    private static final Logger LOG = LoggerFactory.getLogger(JavaKeyStoreProvider.class);
    public static final String SCHEME_NAME = "jceks";
    public static final String KEYSTORE_PASSWORD_FILE_KEY = "hadoop.security.keystore.java-keystore-provider.password-file";
    public static final String KEYSTORE_PASSWORD_ENV_VAR = "HADOOP_KEYSTORE_PASSWORD";
    public static final char[] KEYSTORE_PASSWORD_DEFAULT = "none".toCharArray();
    private final URI uri;
    private final Path path;
    private final FileSystem fs;
    private FsPermission permissions;
    private KeyStore keyStore;
    private char[] password;
    private boolean changed = false;
    private Lock readLock;
    private Lock writeLock;
    private final Map<String, KeyProvider.Metadata> cache = new HashMap<String, KeyProvider.Metadata>();

    @VisibleForTesting
    JavaKeyStoreProvider(JavaKeyStoreProvider other) {
        super(new Configuration());
        this.uri = other.uri;
        this.path = other.path;
        this.fs = other.fs;
        this.permissions = other.permissions;
        this.keyStore = other.keyStore;
        this.password = other.password;
        this.changed = other.changed;
        this.readLock = other.readLock;
        this.writeLock = other.writeLock;
    }

    private JavaKeyStoreProvider(URI uri, Configuration conf) throws IOException {
        super(conf);
        this.uri = uri;
        this.path = ProviderUtils.unnestUri(uri);
        this.fs = this.path.getFileSystem(conf);
        this.locateKeystore();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    private void locateKeystore() throws IOException {
        try {
            this.password = ProviderUtils.locatePassword(KEYSTORE_PASSWORD_ENV_VAR, this.getConf().get(KEYSTORE_PASSWORD_FILE_KEY));
            if (this.password == null) {
                this.password = KEYSTORE_PASSWORD_DEFAULT;
            }
            Path oldPath = JavaKeyStoreProvider.constructOldPath(this.path);
            Path newPath = JavaKeyStoreProvider.constructNewPath(this.path);
            this.keyStore = KeyStore.getInstance(SCHEME_NAME);
            FsPermission perm = null;
            if (this.fs.exists(this.path)) {
                if (this.fs.exists(newPath)) {
                    throw new IOException(String.format("Keystore not loaded due to some inconsistency ('%s' and '%s' should not exist together)!!", this.path, newPath));
                }
                perm = this.tryLoadFromPath(this.path, oldPath);
            } else {
                perm = this.tryLoadIncompleteFlush(oldPath, newPath);
            }
            this.permissions = perm;
        }
        catch (KeyStoreException e) {
            throw new IOException("Can't create keystore: " + e, e);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Can't load keystore " + this.path + " : " + e, e);
        }
    }

    private FsPermission tryLoadFromPath(Path path, Path backupPath) throws NoSuchAlgorithmException, CertificateException, IOException {
        FsPermission perm = null;
        try {
            perm = this.loadFromPath(path, this.password);
            this.fs.delete(backupPath, true);
            LOG.debug("KeyStore loaded successfully !!");
        }
        catch (IOException ioe) {
            if (!this.isBadorWrongPassword(ioe)) {
                perm = this.loadFromPath(backupPath, this.password);
                this.renameOrFail(path, new Path(path.toString() + "_CORRUPTED_" + System.currentTimeMillis()));
                this.renameOrFail(backupPath, path);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("KeyStore loaded successfully from '%s' since '%s'was corrupted !!", backupPath, path));
                }
            }
            throw ioe;
        }
        return perm;
    }

    private FsPermission tryLoadIncompleteFlush(Path oldPath, Path newPath) throws IOException, NoSuchAlgorithmException, CertificateException {
        FsPermission perm = null;
        if (this.fs.exists(newPath)) {
            perm = this.loadAndReturnPerm(newPath, oldPath);
        }
        if (perm == null && this.fs.exists(oldPath)) {
            perm = this.loadAndReturnPerm(oldPath, newPath);
        }
        if (perm == null) {
            this.keyStore.load(null, this.password);
            LOG.debug("KeyStore initialized anew successfully !!");
            perm = new FsPermission("600");
        }
        return perm;
    }

    private FsPermission loadAndReturnPerm(Path pathToLoad, Path pathToDelete) throws NoSuchAlgorithmException, CertificateException, IOException {
        FsPermission perm;
        block3: {
            perm = null;
            try {
                perm = this.loadFromPath(pathToLoad, this.password);
                this.renameOrFail(pathToLoad, this.path);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("KeyStore loaded successfully from '%s'!!", pathToLoad));
                }
                this.fs.delete(pathToDelete, true);
            }
            catch (IOException e) {
                if (!this.isBadorWrongPassword(e)) break block3;
                throw e;
            }
        }
        return perm;
    }

    private boolean isBadorWrongPassword(IOException ioe) {
        if (ioe.getCause() instanceof UnrecoverableKeyException) {
            return true;
        }
        return ioe.getCause() == null && ioe.getMessage() != null && (ioe.getMessage().contains("Keystore was tampered") || ioe.getMessage().contains("password was incorrect"));
    }

    private FsPermission loadFromPath(Path p, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (FSDataInputStream in = this.fs.open(p);){
            FileStatus s = this.fs.getFileStatus(p);
            this.keyStore.load(in, password);
            FsPermission fsPermission = s.getPermission();
            return fsPermission;
        }
    }

    private static Path constructNewPath(Path path) {
        return new Path(path.toString() + "_NEW");
    }

    private static Path constructOldPath(Path path) {
        return new Path(path.toString() + "_OLD");
    }

    @Override
    public boolean needsPassword() throws IOException {
        return null == ProviderUtils.locatePassword(KEYSTORE_PASSWORD_ENV_VAR, this.getConf().get(KEYSTORE_PASSWORD_FILE_KEY));
    }

    @Override
    public String noPasswordWarning() {
        return ProviderUtils.noPasswordWarning(KEYSTORE_PASSWORD_ENV_VAR, KEYSTORE_PASSWORD_FILE_KEY);
    }

    @Override
    public String noPasswordError() {
        return ProviderUtils.noPasswordError(KEYSTORE_PASSWORD_ENV_VAR, KEYSTORE_PASSWORD_FILE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
        this.readLock.lock();
        try {
            SecretKeySpec key;
            block9: {
                key = null;
                if (this.keyStore.containsAlias(versionName)) break block9;
                KeyProvider.KeyVersion keyVersion = null;
                return keyVersion;
            }
            try {
                key = (SecretKeySpec)this.keyStore.getKey(versionName, this.password);
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't get key " + versionName + " from " + this.path, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Can't get algorithm for key " + key + " from " + this.path, e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IOException("Can't recover key " + key + " from " + this.path, e);
            }
            KeyProvider.KeyVersion keyVersion = new KeyProvider.KeyVersion(JavaKeyStoreProvider.getBaseName(versionName), versionName, key.getEncoded());
            return keyVersion;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getKeys() throws IOException {
        this.readLock.lock();
        try {
            ArrayList<String> list = new ArrayList<String>();
            String alias = null;
            try {
                Enumeration<String> e = this.keyStore.aliases();
                while (e.hasMoreElements()) {
                    alias = e.nextElement();
                    if (alias.contains("@")) continue;
                    list.add(alias);
                }
            }
            catch (KeyStoreException e) {
                throw new IOException("Can't get key " + alias + " from " + this.path, e);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
        this.readLock.lock();
        try {
            ArrayList<KeyProvider.KeyVersion> list = new ArrayList<KeyProvider.KeyVersion>();
            KeyProvider.Metadata km = this.getMetadata(name);
            if (km != null) {
                int latestVersion = km.getVersions();
                KeyProvider.KeyVersion v = null;
                String versionName = null;
                for (int i = 0; i < latestVersion; ++i) {
                    versionName = JavaKeyStoreProvider.buildVersionName(name, i);
                    v = this.getKeyVersion(versionName);
                    if (v == null) continue;
                    list.add(v);
                }
            }
            ArrayList<KeyProvider.KeyVersion> arrayList = list;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public KeyProvider.Metadata getMetadata(String name) throws IOException {
        this.readLock.lock();
        try {
            if (this.cache.containsKey(name)) {
                KeyProvider.Metadata metadata = this.cache.get(name);
                return metadata;
            }
            if (!this.keyStore.containsAlias(name)) {
                KeyProvider.Metadata metadata = null;
                return metadata;
            }
            KeyProvider.Metadata meta = ((KeyMetadata)this.keyStore.getKey(name, this.password)).metadata;
            this.cache.put(name, meta);
            KeyProvider.Metadata metadata = meta;
            return metadata;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
        Preconditions.checkArgument(name.equals(StringUtils.toLowerCase(name)), "Uppercase key names are unsupported: %s", name);
        this.writeLock.lock();
        try {
            try {
                if (this.keyStore.containsAlias(name) || this.cache.containsKey(name)) {
                    throw new IOException("Key " + name + " already exists in " + this);
                }
            }
            catch (KeyStoreException e) {
                throw new IOException("Problem looking up key " + name + " in " + this, e);
            }
            KeyProvider.Metadata meta = new KeyProvider.Metadata(options.getCipher(), options.getBitLength(), options.getDescription(), options.getAttributes(), new Date(), 1);
            if (options.getBitLength() != 8 * material.length) {
                throw new IOException("Wrong key length. Required " + options.getBitLength() + ", but got " + 8 * material.length);
            }
            this.cache.put(name, meta);
            String versionName = JavaKeyStoreProvider.buildVersionName(name, 0);
            KeyProvider.KeyVersion keyVersion = this.innerSetKeyVersion(name, versionName, material, meta.getCipher());
            return keyVersion;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteKey(String name) throws IOException {
        this.writeLock.lock();
        try {
            KeyProvider.Metadata meta = this.getMetadata(name);
            if (meta == null) {
                throw new IOException("Key " + name + " does not exist in " + this);
            }
            for (int v = 0; v < meta.getVersions(); ++v) {
                String versionName = JavaKeyStoreProvider.buildVersionName(name, v);
                try {
                    if (!this.keyStore.containsAlias(versionName)) continue;
                    this.keyStore.deleteEntry(versionName);
                    continue;
                }
                catch (KeyStoreException e) {
                    throw new IOException("Problem removing " + versionName + " from " + this, e);
                }
            }
            try {
                if (this.keyStore.containsAlias(name)) {
                    this.keyStore.deleteEntry(name);
                }
            }
            catch (KeyStoreException e) {
                throw new IOException("Problem removing " + name + " from " + this, e);
            }
            this.cache.remove(name);
            this.changed = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    KeyProvider.KeyVersion innerSetKeyVersion(String name, String versionName, byte[] material, String cipher) throws IOException {
        try {
            this.keyStore.setKeyEntry(versionName, new SecretKeySpec(material, cipher), this.password, null);
        }
        catch (KeyStoreException e) {
            throw new IOException("Can't store key " + versionName + " in " + this, e);
        }
        this.changed = true;
        return new KeyProvider.KeyVersion(name, versionName, material);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        this.writeLock.lock();
        try {
            KeyProvider.Metadata meta = this.getMetadata(name);
            if (meta == null) {
                throw new IOException("Key " + name + " not found");
            }
            if (meta.getBitLength() != 8 * material.length) {
                throw new IOException("Wrong key length. Required " + meta.getBitLength() + ", but got " + 8 * material.length);
            }
            int nextVersion = meta.addVersion();
            String versionName = JavaKeyStoreProvider.buildVersionName(name, nextVersion);
            KeyProvider.KeyVersion keyVersion = this.innerSetKeyVersion(name, versionName, material, meta.getCipher());
            return keyVersion;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        Path newPath = JavaKeyStoreProvider.constructNewPath(this.path);
        Path oldPath = JavaKeyStoreProvider.constructOldPath(this.path);
        Path resetPath = this.path;
        this.writeLock.lock();
        try {
            if (!this.changed) {
                return;
            }
            try {
                this.renameOrFail(newPath, new Path(newPath.toString() + "_ORPHANED_" + System.currentTimeMillis()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            try {
                this.renameOrFail(oldPath, new Path(oldPath.toString() + "_ORPHANED_" + System.currentTimeMillis()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            for (Map.Entry<String, KeyProvider.Metadata> entry : this.cache.entrySet()) {
                try {
                    this.keyStore.setKeyEntry(entry.getKey(), new KeyMetadata(entry.getValue()), this.password, null);
                }
                catch (KeyStoreException e) {
                    throw new IOException("Can't set metadata key " + entry.getKey(), e);
                }
            }
            boolean fileExisted = this.backupToOld(oldPath);
            if (fileExisted) {
                resetPath = oldPath;
            }
            try {
                this.writeToNew(newPath);
            }
            catch (IOException ioe) {
                this.revertFromOld(oldPath, fileExisted);
                resetPath = this.path;
                throw ioe;
            }
            this.cleanupNewAndOld(newPath, oldPath);
            this.changed = false;
        }
        catch (IOException ioe) {
            this.resetKeyStoreState(resetPath);
            throw ioe;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void resetKeyStoreState(Path path) {
        LOG.debug("Could not flush Keystore..attempting to reset to previous state !!");
        this.cache.clear();
        try {
            this.loadFromPath(path, this.password);
            LOG.debug("KeyStore resetting to previously flushed state !!");
        }
        catch (Exception e) {
            LOG.debug("Could not reset Keystore to previous state", (Throwable)e);
        }
    }

    private void cleanupNewAndOld(Path newPath, Path oldPath) throws IOException {
        this.renameOrFail(newPath, this.path);
        this.fs.delete(oldPath, true);
    }

    protected void writeToNew(Path newPath) throws IOException {
        try (FSDataOutputStream out = FileSystem.create(this.fs, newPath, this.permissions);){
            this.keyStore.store(out, this.password);
        }
        catch (KeyStoreException e) {
            throw new IOException("Can't store keystore " + this, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("No such algorithm storing keystore " + this, e);
        }
        catch (CertificateException e) {
            throw new IOException("Certificate exception storing keystore " + this, e);
        }
    }

    protected boolean backupToOld(Path oldPath) throws IOException {
        try {
            this.renameOrFail(this.path, oldPath);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    private void revertFromOld(Path oldPath, boolean fileExisted) throws IOException {
        if (fileExisted) {
            this.renameOrFail(oldPath, this.path);
        }
    }

    private void renameOrFail(Path src, Path dest) throws IOException {
        if (!this.fs.rename(src, dest)) {
            throw new IOException("Rename unsuccessful : " + String.format("'%s' to '%s'", src, dest));
        }
    }

    public String toString() {
        return this.uri.toString();
    }

    public static class KeyMetadata
    implements Key,
    Serializable {
        private KeyProvider.Metadata metadata;
        private static final long serialVersionUID = 8405872419967874451L;

        private KeyMetadata(KeyProvider.Metadata meta) {
            this.metadata = meta;
        }

        @Override
        public String getAlgorithm() {
            return this.metadata.getCipher();
        }

        @Override
        public String getFormat() {
            return JavaKeyStoreProvider.KEY_METADATA;
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            byte[] serialized = this.metadata.serialize();
            out.writeInt(serialized.length);
            out.write(serialized);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            this.metadata = new KeyProvider.Metadata(buf);
        }
    }

    public static class Factory
    extends KeyProviderFactory {
        @Override
        public KeyProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (JavaKeyStoreProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                return new JavaKeyStoreProvider(providerName, conf);
            }
            return null;
        }
    }
}

