/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.com.google.re2j.PatternSyntaxException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.GlobPattern;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathFilter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class GlobFilter
implements PathFilter {
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return true;
        }
    };
    private PathFilter userFilter = DEFAULT_FILTER;
    private GlobPattern pattern;

    public GlobFilter(String filePattern) throws IOException {
        this.init(filePattern, DEFAULT_FILTER);
    }

    public GlobFilter(String filePattern, PathFilter filter) throws IOException {
        this.init(filePattern, filter);
    }

    void init(String filePattern, PathFilter filter) throws IOException {
        try {
            this.userFilter = filter;
            this.pattern = new GlobPattern(filePattern);
        }
        catch (PatternSyntaxException e) {
            throw new IOException("Illegal file pattern: " + e.getMessage(), e);
        }
    }

    public boolean hasPattern() {
        return this.pattern.hasWildcard();
    }

    @Override
    public boolean accept(Path path) {
        return this.pattern.matches(path.getName()) && this.userFilter.accept(path);
    }
}

