/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FsShellPermissions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.AclCommands;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Command;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.CopyCommands;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Count;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Delete;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Display;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.FsUsage;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Head;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Ls;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Mkdir;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.MoveCommands;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.PathData;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.SetReplication;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.SnapshotCommands;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Stat;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Tail;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Test;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Touch;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.Truncate;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.XAttrCommands;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.shell.find.Find;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class FsCommand
extends Command {
    public static void registerCommands(CommandFactory factory) {
        factory.registerCommands(AclCommands.class);
        factory.registerCommands(CopyCommands.class);
        factory.registerCommands(Count.class);
        factory.registerCommands(Delete.class);
        factory.registerCommands(Display.class);
        factory.registerCommands(Find.class);
        factory.registerCommands(FsShellPermissions.class);
        factory.registerCommands(FsUsage.class);
        factory.registerCommands(Ls.class);
        factory.registerCommands(Mkdir.class);
        factory.registerCommands(MoveCommands.class);
        factory.registerCommands(SetReplication.class);
        factory.registerCommands(Stat.class);
        factory.registerCommands(Tail.class);
        factory.registerCommands(Head.class);
        factory.registerCommands(Test.class);
        factory.registerCommands(Touch.class);
        factory.registerCommands(Truncate.class);
        factory.registerCommands(SnapshotCommands.class);
        factory.registerCommands(XAttrCommands.class);
    }

    protected FsCommand() {
    }

    protected FsCommand(Configuration conf) {
        super(conf);
    }

    @Override
    public String getCommandName() {
        return this.getName();
    }

    @Override
    protected void run(Path path) throws IOException {
        throw new RuntimeException("not supposed to get here");
    }

    @Override
    @Deprecated
    public int runAll() {
        return this.run(this.args);
    }

    @Override
    protected void processRawArguments(LinkedList<String> args) throws IOException {
        LinkedList<PathData> expendedArgs = this.expandArguments(args);
        boolean displayWarnings = this.getConf().getBoolean("hadoop.shell.missing.defaultFs.warning", false);
        if (displayWarnings) {
            boolean missingDefaultFs;
            String defaultFs = this.getConf().get("fs.defaultFS");
            boolean bl = missingDefaultFs = defaultFs == null || defaultFs.equals("file:///");
            if (missingDefaultFs) {
                this.err.printf("Warning: fs.defaultFS is not set when running \"%s\" command.%n", this.getCommandName());
            }
        }
        this.processArguments(expendedArgs);
    }
}

