/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc.RetriableException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc.Server;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc.StandbyException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.AccessControlException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.SaslPlainServer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.SecretManager;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SaslRpcServer {
    public static final Logger LOG = LoggerFactory.getLogger(SaslRpcServer.class);
    public static final String SASL_DEFAULT_REALM = "default";
    private static SaslServerFactory saslFactory;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public AuthMethod authMethod;
    public String mechanism;
    public String protocol;
    public String serverId;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public SaslRpcServer(AuthMethod authMethod) throws IOException {
        this.authMethod = authMethod;
        this.mechanism = authMethod.getMechanismName();
        switch (authMethod) {
            case SIMPLE: {
                return;
            }
            case TOKEN: {
                this.protocol = "";
                this.serverId = SASL_DEFAULT_REALM;
                break;
            }
            case KERBEROS: {
                String fullName = UserGroupInformation.getCurrentUser().getUserName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Kerberos principal name is " + fullName);
                }
                String[] parts = fullName.split("[/@]", 3);
                this.protocol = parts[0];
                this.serverId = parts.length < 2 ? "" : parts[1];
                break;
            }
            default: {
                throw new AccessControlException("Server does not support SASL " + (Object)((Object)authMethod));
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public SaslServer create(Server.Connection connection, final Map<String, ?> saslProperties, SecretManager<TokenIdentifier> secretManager) throws IOException, InterruptedException {
        CallbackHandler callback;
        UserGroupInformation ugi = null;
        switch (this.authMethod) {
            case TOKEN: {
                callback = new SaslDigestCallbackHandler(secretManager, connection);
                break;
            }
            case KERBEROS: {
                ugi = UserGroupInformation.getCurrentUser();
                if (this.serverId.isEmpty()) {
                    throw new AccessControlException("Kerberos principal name does NOT have the expected hostname part: " + ugi.getUserName());
                }
                callback = new SaslGssCallbackHandler();
                break;
            }
            default: {
                throw new AccessControlException("Server does not support SASL " + (Object)((Object)this.authMethod));
            }
        }
        SaslServer saslServer = ugi != null ? ugi.doAs(new PrivilegedExceptionAction<SaslServer>(){

            @Override
            public SaslServer run() throws SaslException {
                return saslFactory.createSaslServer(SaslRpcServer.this.mechanism, SaslRpcServer.this.protocol, SaslRpcServer.this.serverId, saslProperties, callback);
            }
        }) : saslFactory.createSaslServer(this.mechanism, this.protocol, this.serverId, saslProperties, callback);
        if (saslServer == null) {
            throw new AccessControlException("Unable to find SASL server implementation for " + this.mechanism);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created SASL server with mechanism = " + this.mechanism);
        }
        return saslServer;
    }

    public static void init(Configuration conf) {
        Security.addProvider(new SaslPlainServer.SecurityProvider());
        saslFactory = new FastSaslServerFactory(null);
    }

    static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64(identifier), StandardCharsets.UTF_8);
    }

    static byte[] decodeIdentifier(String identifier) {
        return Base64.decodeBase64(identifier.getBytes(StandardCharsets.UTF_8));
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = SaslRpcServer.decodeIdentifier(id);
        T tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields(new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause(e);
        }
        return tokenIdentifier;
    }

    static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64(password), StandardCharsets.UTF_8).toCharArray();
    }

    public static String[] splitKerberosName(String fullName) {
        return fullName.split("[/@]");
    }

    private static class FastSaslServerFactory
    implements SaslServerFactory {
        private final Map<String, List<SaslServerFactory>> factoryCache = new HashMap<String, List<SaslServerFactory>>();

        FastSaslServerFactory(Map<String, ?> props) {
            Enumeration<SaslServerFactory> factories = Sasl.getSaslServerFactories();
            while (factories.hasMoreElements()) {
                SaslServerFactory factory = factories.nextElement();
                for (String mech : factory.getMechanismNames(props)) {
                    if (!this.factoryCache.containsKey(mech)) {
                        this.factoryCache.put(mech, new ArrayList());
                    }
                    this.factoryCache.get(mech).add(factory);
                }
            }
        }

        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            SaslServer saslServer;
            block1: {
                SaslServerFactory factory;
                saslServer = null;
                List<SaslServerFactory> factories = this.factoryCache.get(mechanism);
                if (factories == null) break block1;
                Iterator<SaslServerFactory> iterator = factories.iterator();
                while (iterator.hasNext() && (saslServer = (factory = iterator.next()).createSaslServer(mechanism, protocol, serverName, props, cbh)) == null) {
                }
            }
            return saslServer;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return this.factoryCache.keySet().toArray(new String[0]);
        }
    }

    @InterfaceStability.Evolving
    public static class SaslGssCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("SASL server GSSAPI callback: setting canonicalized client ID: " + authzid);
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }

    @InterfaceStability.Evolving
    public static class SaslDigestCallbackHandler
    implements CallbackHandler {
        private SecretManager<TokenIdentifier> secretManager;
        private Server.Connection connection;

        public SaslDigestCallbackHandler(SecretManager<TokenIdentifier> secretManager, Server.Connection connection) {
            this.secretManager = secretManager;
            this.connection = connection;
        }

        private char[] getPassword(TokenIdentifier tokenid) throws SecretManager.InvalidToken, StandbyException, RetriableException, IOException {
            return SaslRpcServer.encodePassword(this.secretManager.retriableRetrievePassword(tokenid));
        }

        @Override
        public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException, StandbyException, RetriableException, IOException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
            if (pc != null) {
                TokenIdentifier tokenIdentifier = SaslRpcServer.getIdentifier(nc.getDefaultName(), this.secretManager);
                char[] password = this.getPassword(tokenIdentifier);
                UserGroupInformation user = null;
                this.connection.attemptingUser = user = tokenIdentifier.getUser();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser());
                }
                pc.setPassword(password);
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        UserGroupInformation logUser = SaslRpcServer.getIdentifier(authzid, this.secretManager).getUser();
                        String username = logUser == null ? null : logUser.getUserName();
                        LOG.debug("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username);
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }

    @InterfaceStability.Evolving
    public static enum AuthMethod {
        SIMPLE(80, ""),
        KERBEROS(81, "GSSAPI"),
        DIGEST(82, "DIGEST-MD5"),
        TOKEN(82, "DIGEST-MD5"),
        PLAIN(83, "PLAIN");

        public final byte code;
        public final String mechanismName;
        private static final int FIRST_CODE;

        private AuthMethod(byte code, String mechanismName) {
            this.code = code;
            this.mechanismName = mechanismName;
        }

        private static AuthMethod valueOf(byte code) {
            int i = (code & 0xFF) - FIRST_CODE;
            return i < 0 || i >= AuthMethod.values().length ? null : AuthMethod.values()[i];
        }

        public String getMechanismName() {
            return this.mechanismName;
        }

        public static AuthMethod read(DataInput in) throws IOException {
            return AuthMethod.valueOf(in.readByte());
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.code);
        }

        static {
            FIRST_CODE = AuthMethod.values()[0].code;
        }
    }

    public static enum QualityOfProtection {
        AUTHENTICATION("auth"),
        INTEGRITY("auth-int"),
        PRIVACY("auth-conf");

        public final String saslQop;

        private QualityOfProtection(String saslQop) {
            this.saslQop = saslQop;
        }

        public String getSaslQop() {
            return this.saslQop;
        }
    }
}

