/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.CpuTimeTracker;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Shell;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.SysInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SysInfoLinux
extends SysInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SysInfoLinux.class);
    private static final String PROCFS_MEMFILE = "/proc/meminfo";
    private static final Pattern PROCFS_MEMFILE_FORMAT = Pattern.compile("^([a-zA-Z_()]*):[ \t]*([0-9]*)[ \t]*(kB)?");
    private static final String MEMTOTAL_STRING = "MemTotal";
    private static final String SWAPTOTAL_STRING = "SwapTotal";
    private static final String MEMFREE_STRING = "MemFree";
    private static final String SWAPFREE_STRING = "SwapFree";
    private static final String INACTIVE_STRING = "Inactive";
    private static final String INACTIVEFILE_STRING = "Inactive(file)";
    private static final String HARDWARECORRUPTED_STRING = "HardwareCorrupted";
    private static final String HUGEPAGESTOTAL_STRING = "HugePages_Total";
    private static final String HUGEPAGESIZE_STRING = "Hugepagesize";
    private static final String PROCFS_CPUINFO = "/proc/cpuinfo";
    private static final Pattern PROCESSOR_FORMAT = Pattern.compile("^processor[ \t]:[ \t]*([0-9]*)");
    private static final Pattern FREQUENCY_FORMAT = Pattern.compile("^cpu MHz[ \t]*:[ \t]*([0-9.]*)");
    private static final Pattern PHYSICAL_ID_FORMAT = Pattern.compile("^physical id[ \t]*:[ \t]*([0-9]*)");
    private static final Pattern CORE_ID_FORMAT = Pattern.compile("^core id[ \t]*:[ \t]*([0-9]*)");
    private static final String PROCFS_STAT = "/proc/stat";
    private static final Pattern CPU_TIME_FORMAT = Pattern.compile("^cpu[ \t]*([0-9]*)[ \t]*([0-9]*)[ \t]*([0-9]*)[ \t].*");
    private CpuTimeTracker cpuTimeTracker;
    private static final String PROCFS_NETFILE = "/proc/net/dev";
    private static final Pattern PROCFS_NETFILE_FORMAT = Pattern.compile("^[ \t]*([a-zA-Z]+[0-9]*):[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+).*");
    private static final String PROCFS_DISKSFILE = "/proc/diskstats";
    private static final Pattern PROCFS_DISKSFILE_FORMAT = Pattern.compile("^[ \t]*([0-9]+)[ \t]*([0-9 ]+)(?!([a-zA-Z]+[0-9]+))([a-zA-Z]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)[ \t]*([0-9]+)");
    private static final Pattern PROCFS_DISKSECTORFILE_FORMAT = Pattern.compile("^([0-9]+)");
    private String procfsMemFile;
    private String procfsCpuFile;
    private String procfsStatFile;
    private String procfsNetFile;
    private String procfsDisksFile;
    private long jiffyLengthInMillis;
    private long ramSize = 0L;
    private long swapSize = 0L;
    private long ramSizeFree = 0L;
    private long swapSizeFree = 0L;
    private long inactiveSize = 0L;
    private long inactiveFileSize = -1L;
    private long hardwareCorruptSize = 0L;
    private long hugePagesTotal = 0L;
    private long hugePageSize = 0L;
    private int numProcessors = 0;
    private int numCores = 0;
    private long cpuFrequency = 0L;
    private long numNetBytesRead = 0L;
    private long numNetBytesWritten = 0L;
    private long numDisksBytesRead = 0L;
    private long numDisksBytesWritten = 0L;
    private boolean readMemInfoFile = false;
    private boolean readCpuInfoFile = false;
    private HashMap<String, Integer> perDiskSectorSize = null;
    public static final long PAGE_SIZE = SysInfoLinux.getConf("PAGESIZE");
    public static final long JIFFY_LENGTH_IN_MILLIS = Math.max(Math.round(1000.0 / (double)SysInfoLinux.getConf("CLK_TCK")), -1L);

    private static long getConf(String attr) {
        if (Shell.LINUX) {
            try {
                Shell.ShellCommandExecutor shellExecutorClk = new Shell.ShellCommandExecutor(new String[]{"getconf", attr});
                shellExecutorClk.execute();
                return Long.parseLong(shellExecutorClk.getOutput().replace("\n", ""));
            }
            catch (IOException | NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public SysInfoLinux() {
        this(PROCFS_MEMFILE, PROCFS_CPUINFO, PROCFS_STAT, PROCFS_NETFILE, PROCFS_DISKSFILE, JIFFY_LENGTH_IN_MILLIS);
    }

    @VisibleForTesting
    public SysInfoLinux(String procfsMemFile, String procfsCpuFile, String procfsStatFile, String procfsNetFile, String procfsDisksFile, long jiffyLengthInMillis) {
        this.procfsMemFile = procfsMemFile;
        this.procfsCpuFile = procfsCpuFile;
        this.procfsStatFile = procfsStatFile;
        this.procfsNetFile = procfsNetFile;
        this.procfsDisksFile = procfsDisksFile;
        this.jiffyLengthInMillis = jiffyLengthInMillis;
        this.cpuTimeTracker = new CpuTimeTracker(jiffyLengthInMillis);
        this.perDiskSectorSize = new HashMap();
    }

    private void readProcMemInfoFile() {
        this.readProcMemInfoFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcMemInfoFile(boolean readAgain) {
        BufferedReader in;
        InputStreamReader fReader;
        if (this.readMemInfoFile && !readAgain) {
            return;
        }
        try {
            fReader = new InputStreamReader((InputStream)new FileInputStream(this.procfsMemFile), Charset.forName("UTF-8"));
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            LOG.warn("Couldn't read " + this.procfsMemFile + "; can't determine memory settings");
            return;
        }
        try {
            String str = in.readLine();
            while (str != null) {
                Matcher mat = PROCFS_MEMFILE_FORMAT.matcher(str);
                if (mat.find()) {
                    if (mat.group(1).equals(MEMTOTAL_STRING)) {
                        this.ramSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(SWAPTOTAL_STRING)) {
                        this.swapSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(MEMFREE_STRING)) {
                        this.ramSizeFree = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(SWAPFREE_STRING)) {
                        this.swapSizeFree = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(INACTIVE_STRING)) {
                        this.inactiveSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(INACTIVEFILE_STRING)) {
                        this.inactiveFileSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(HARDWARECORRUPTED_STRING)) {
                        this.hardwareCorruptSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(HUGEPAGESTOTAL_STRING)) {
                        this.hugePagesTotal = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(HUGEPAGESIZE_STRING)) {
                        this.hugePageSize = Long.parseLong(mat.group(2));
                    }
                }
                str = in.readLine();
            }
        }
        catch (IOException io) {
            LOG.warn("Error reading the stream " + io);
        }
        finally {
            try {
                fReader.close();
                try {
                    in.close();
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + in);
                }
            }
            catch (IOException i) {
                LOG.warn("Error closing the stream " + fReader);
            }
        }
        this.readMemInfoFile = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcCpuInfoFile() {
        BufferedReader in;
        InputStreamReader fReader;
        if (this.readCpuInfoFile) {
            return;
        }
        HashSet<String> coreIdSet = new HashSet<String>();
        try {
            fReader = new InputStreamReader((InputStream)new FileInputStream(this.procfsCpuFile), Charset.forName("UTF-8"));
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            LOG.warn("Couldn't read " + this.procfsCpuFile + "; can't determine cpu info");
            return;
        }
        try {
            this.numProcessors = 0;
            this.numCores = 1;
            String currentPhysicalId = "";
            String str = in.readLine();
            while (str != null) {
                Matcher mat = PROCESSOR_FORMAT.matcher(str);
                if (mat.find()) {
                    ++this.numProcessors;
                }
                if ((mat = FREQUENCY_FORMAT.matcher(str)).find()) {
                    this.cpuFrequency = (long)(Double.parseDouble(mat.group(1)) * 1000.0);
                }
                if ((mat = PHYSICAL_ID_FORMAT.matcher(str)).find()) {
                    currentPhysicalId = str;
                }
                if ((mat = CORE_ID_FORMAT.matcher(str)).find()) {
                    coreIdSet.add(currentPhysicalId + " " + str);
                    this.numCores = coreIdSet.size();
                }
                str = in.readLine();
            }
        }
        catch (IOException io) {
            LOG.warn("Error reading the stream " + io);
        }
        finally {
            try {
                fReader.close();
                try {
                    in.close();
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + in);
                }
            }
            catch (IOException i) {
                LOG.warn("Error closing the stream " + fReader);
            }
        }
        this.readCpuInfoFile = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcStatFile() {
        BufferedReader in;
        InputStreamReader fReader;
        try {
            fReader = new InputStreamReader((InputStream)new FileInputStream(this.procfsStatFile), Charset.forName("UTF-8"));
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            return;
        }
        try {
            String str = in.readLine();
            while (str != null) {
                Matcher mat = CPU_TIME_FORMAT.matcher(str);
                if (mat.find()) {
                    long uTime = Long.parseLong(mat.group(1));
                    long nTime = Long.parseLong(mat.group(2));
                    long sTime = Long.parseLong(mat.group(3));
                    this.cpuTimeTracker.updateElapsedJiffies(BigInteger.valueOf(uTime + nTime + sTime), this.getCurrentTime());
                    break;
                }
                str = in.readLine();
            }
        }
        catch (IOException io) {
            LOG.warn("Error reading the stream " + io);
        }
        finally {
            try {
                fReader.close();
                try {
                    in.close();
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + in);
                }
            }
            catch (IOException i) {
                LOG.warn("Error closing the stream " + fReader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcNetInfoFile() {
        BufferedReader in;
        InputStreamReader fReader;
        this.numNetBytesRead = 0L;
        this.numNetBytesWritten = 0L;
        try {
            fReader = new InputStreamReader((InputStream)new FileInputStream(this.procfsNetFile), Charset.forName("UTF-8"));
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            return;
        }
        try {
            String str = in.readLine();
            while (str != null) {
                Matcher mat = PROCFS_NETFILE_FORMAT.matcher(str);
                if (mat.find()) {
                    assert (mat.groupCount() >= 16);
                    if (mat.group(1).equals("lo")) {
                        str = in.readLine();
                        continue;
                    }
                    this.numNetBytesRead += Long.parseLong(mat.group(2));
                    this.numNetBytesWritten += Long.parseLong(mat.group(10));
                }
                str = in.readLine();
            }
        }
        catch (IOException io) {
            LOG.warn("Error reading the stream " + io);
        }
        finally {
            try {
                fReader.close();
                try {
                    in.close();
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + in);
                }
            }
            catch (IOException i) {
                LOG.warn("Error closing the stream " + fReader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcDisksInfoFile() {
        BufferedReader in;
        this.numDisksBytesRead = 0L;
        this.numDisksBytesWritten = 0L;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.procfsDisksFile), Charset.forName("UTF-8")));
        }
        catch (FileNotFoundException f) {
            return;
        }
        try {
            String str = in.readLine();
            while (str != null) {
                Matcher mat = PROCFS_DISKSFILE_FORMAT.matcher(str);
                if (mat.find()) {
                    Integer sectorSize;
                    String diskName = mat.group(4);
                    assert (diskName != null);
                    if (diskName.contains("loop") || diskName.contains("ram")) {
                        str = in.readLine();
                        continue;
                    }
                    HashMap<String, Integer> hashMap = this.perDiskSectorSize;
                    synchronized (hashMap) {
                        sectorSize = this.perDiskSectorSize.get(diskName);
                        if (null == sectorSize) {
                            sectorSize = this.readDiskBlockInformation(diskName, 512);
                            this.perDiskSectorSize.put(diskName, sectorSize);
                        }
                    }
                    String sectorsRead = mat.group(7);
                    String sectorsWritten = mat.group(11);
                    if (null == sectorsRead || null == sectorsWritten) {
                        return;
                    }
                    this.numDisksBytesRead += Long.parseLong(sectorsRead) * (long)sectorSize.intValue();
                    this.numDisksBytesWritten += Long.parseLong(sectorsWritten) * (long)sectorSize.intValue();
                }
                str = in.readLine();
            }
        }
        catch (IOException e) {
            LOG.warn("Error reading the stream " + this.procfsDisksFile, (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing the stream " + this.procfsDisksFile, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readDiskBlockInformation(String diskName, int defSector) {
        BufferedReader in;
        assert (this.perDiskSectorSize != null && diskName != null);
        String procfsDiskSectorFile = "/sys/block/" + diskName + "/queue/hw_sector_size";
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(procfsDiskSectorFile), Charset.forName("UTF-8")));
        }
        catch (FileNotFoundException f) {
            return defSector;
        }
        try {
            String str = in.readLine();
            while (str != null) {
                String secSize;
                Matcher mat = PROCFS_DISKSECTORFILE_FORMAT.matcher(str);
                if (mat.find() && (secSize = mat.group(1)) != null) {
                    int n = Integer.parseInt(secSize);
                    return n;
                }
                str = in.readLine();
            }
            int n = defSector;
            return n;
        }
        catch (IOException | NumberFormatException e) {
            LOG.warn("Error reading the stream " + procfsDiskSectorFile, (Throwable)e);
            int n = defSector;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing the stream " + procfsDiskSectorFile, (Throwable)e);
            }
        }
    }

    @Override
    public long getPhysicalMemorySize() {
        this.readProcMemInfoFile();
        return (this.ramSize - this.hardwareCorruptSize - this.hugePagesTotal * this.hugePageSize) * 1024L;
    }

    @Override
    public long getVirtualMemorySize() {
        return this.getPhysicalMemorySize() + this.swapSize * 1024L;
    }

    @Override
    public long getAvailablePhysicalMemorySize() {
        this.readProcMemInfoFile(true);
        long inactive = this.inactiveFileSize != -1L ? this.inactiveFileSize : this.inactiveSize;
        return (this.ramSizeFree + inactive) * 1024L;
    }

    @Override
    public long getAvailableVirtualMemorySize() {
        return this.getAvailablePhysicalMemorySize() + this.swapSizeFree * 1024L;
    }

    @Override
    public int getNumProcessors() {
        this.readProcCpuInfoFile();
        return this.numProcessors;
    }

    @Override
    public int getNumCores() {
        this.readProcCpuInfoFile();
        return this.numCores;
    }

    @Override
    public long getCpuFrequency() {
        this.readProcCpuInfoFile();
        return this.cpuFrequency;
    }

    @Override
    public long getCumulativeCpuTime() {
        this.readProcStatFile();
        return this.cpuTimeTracker.getCumulativeCpuTime();
    }

    @Override
    public float getCpuUsagePercentage() {
        this.readProcStatFile();
        float overallCpuUsage = this.cpuTimeTracker.getCpuTrackerUsagePercent();
        if (overallCpuUsage != -1.0f) {
            overallCpuUsage /= (float)this.getNumProcessors();
        }
        return overallCpuUsage;
    }

    @Override
    public float getNumVCoresUsed() {
        this.readProcStatFile();
        float overallVCoresUsage = this.cpuTimeTracker.getCpuTrackerUsagePercent();
        if (overallVCoresUsage != -1.0f) {
            overallVCoresUsage /= 100.0f;
        }
        return overallVCoresUsage;
    }

    @Override
    public long getNetworkBytesRead() {
        this.readProcNetInfoFile();
        return this.numNetBytesRead;
    }

    @Override
    public long getNetworkBytesWritten() {
        this.readProcNetInfoFile();
        return this.numNetBytesWritten;
    }

    @Override
    public long getStorageBytesRead() {
        this.readProcDisksInfoFile();
        return this.numDisksBytesRead;
    }

    @Override
    public long getStorageBytesWritten() {
        this.readProcDisksInfoFile();
        return this.numDisksBytesWritten;
    }

    public static void main(String[] args) {
        SysInfoLinux plugin = new SysInfoLinux();
        System.out.println("Physical memory Size (bytes) : " + plugin.getPhysicalMemorySize());
        System.out.println("Total Virtual memory Size (bytes) : " + plugin.getVirtualMemorySize());
        System.out.println("Available Physical memory Size (bytes) : " + plugin.getAvailablePhysicalMemorySize());
        System.out.println("Total Available Virtual memory Size (bytes) : " + plugin.getAvailableVirtualMemorySize());
        System.out.println("Number of Processors : " + plugin.getNumProcessors());
        System.out.println("CPU frequency (kHz) : " + plugin.getCpuFrequency());
        System.out.println("Cumulative CPU time (ms) : " + plugin.getCumulativeCpuTime());
        System.out.println("Total network read (bytes) : " + plugin.getNetworkBytesRead());
        System.out.println("Total network written (bytes) : " + plugin.getNetworkBytesWritten());
        System.out.println("Total storage read (bytes) : " + plugin.getStorageBytesRead());
        System.out.println("Total storage written (bytes) : " + plugin.getStorageBytesWritten());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("CPU usage % : " + plugin.getCpuUsagePercentage());
    }

    @VisibleForTesting
    void setReadCpuInfoFile(boolean readCpuInfoFileValue) {
        this.readCpuInfoFile = readCpuInfoFileValue;
    }

    public long getJiffyLengthInMillis() {
        return this.jiffyLengthInMillis;
    }
}

