/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenUtils;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;

public class PbCodegenMapSerializer
implements PbCodegenSerializer {
    private final Descriptors.FieldDescriptor fd;
    private final MapType mapType;
    private final PbFormatContext formatContext;

    public PbCodegenMapSerializer(Descriptors.FieldDescriptor fd, MapType mapType, PbFormatContext formatContext) {
        this.fd = fd;
        this.mapType = mapType;
        this.formatContext = formatContext;
    }

    @Override
    public String codegen(String resultVar, String flinkObjectCode, int indent) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        LogicalType keyType = this.mapType.getKeyType();
        LogicalType valueType = this.mapType.getValueType();
        Descriptors.FieldDescriptor keyFd = this.fd.getMessageType().findFieldByName("key");
        Descriptors.FieldDescriptor valueFd = this.fd.getMessageType().findFieldByName("value");
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        String keyProtoTypeStr = PbCodegenUtils.getTypeStrFromProto(keyFd, false, this.formatContext.getOuterPrefix());
        String valueProtoTypeStr = PbCodegenUtils.getTypeStrFromProto(valueFd, false, this.formatContext.getOuterPrefix());
        String flinkKeyArrDataVar = "keyArrData" + uid;
        String flinkValueArrDataVar = "valueArrData" + uid;
        String iVar = "i" + uid;
        String pbMapVar = "resultPbMap" + uid;
        String keyPbVar = "keyPbVar" + uid;
        String valuePbVar = "valuePbVar" + uid;
        appender.appendLine("ArrayData " + flinkKeyArrDataVar + " = " + flinkObjectCode + ".keyArray()");
        appender.appendLine("ArrayData " + flinkValueArrDataVar + " = " + flinkObjectCode + ".valueArray()");
        appender.appendLine("Map<" + keyProtoTypeStr + ", " + valueProtoTypeStr + "> " + pbMapVar + " = new HashMap()");
        appender.begin("for(int " + iVar + " = 0; " + iVar + " < " + flinkKeyArrDataVar + ".size(); " + iVar + "++){");
        String convertFlinkKeyArrayElementToPbCode = PbCodegenUtils.convertFlinkArrayElementToPbWithDefaultValueCode(flinkKeyArrDataVar, iVar, keyPbVar, keyFd, keyType, this.formatContext, appender.currentIndent());
        appender.appendSegment(convertFlinkKeyArrayElementToPbCode);
        String convertFlinkValueArrayElementToPbCode = PbCodegenUtils.convertFlinkArrayElementToPbWithDefaultValueCode(flinkValueArrDataVar, iVar, valuePbVar, valueFd, valueType, this.formatContext, appender.currentIndent());
        appender.appendSegment(convertFlinkValueArrayElementToPbCode);
        appender.appendLine(pbMapVar + ".put(" + keyPbVar + ", " + valuePbVar + ")");
        appender.end("}");
        appender.appendLine(resultVar + " = " + pbMapVar);
        return appender.code();
    }
}

