/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.protobuf.PbFormatConfig;
import org.apache.flink.formats.protobuf.serialize.RowToProtoConverter;
import org.apache.flink.formats.protobuf.util.PbFormatUtils;
import org.apache.flink.formats.protobuf.util.PbSchemaValidationUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;

public class PbRowDataSerializationSchema
implements SerializationSchema<RowData> {
    public static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final PbFormatConfig pbFormatConfig;
    private transient RowToProtoConverter rowToProtoConverter;

    public PbRowDataSerializationSchema(RowType rowType, PbFormatConfig pbFormatConfig) {
        this.rowType = rowType;
        this.pbFormatConfig = pbFormatConfig;
        Descriptors.Descriptor descriptor = PbFormatUtils.getDescriptor(pbFormatConfig.getMessageClassName());
        PbSchemaValidationUtils.validate(descriptor, rowType);
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.rowToProtoConverter = new RowToProtoConverter(this.rowType, this.pbFormatConfig);
    }

    public byte[] serialize(RowData element) {
        try {
            return this.rowToProtoConverter.convertRowToProtoBinary(element);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }
}

