/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.InternalExecutionGraphAccessor;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class ExecutionVertex
implements AccessExecutionVertex,
Archiveable<ArchivedExecutionVertex> {
    private static final Logger LOG = DefaultExecutionGraph.LOG;
    public static final int MAX_DISTINCT_LOCATIONS_TO_CONSIDER = 8;
    private final ExecutionJobVertex jobVertex;
    private final Map<IntermediateResultPartitionID, IntermediateResultPartition> resultPartitions;
    private final int subTaskIndex;
    private final ExecutionVertexID executionVertexId;
    private final EvictingBoundedList<ArchivedExecution> priorExecutions;
    private final Time timeout;
    private final String taskNameWithSubtask;
    private Execution currentExecution;
    private final ArrayList<InputSplit> inputSplits;

    @VisibleForTesting
    public ExecutionVertex(ExecutionJobVertex jobVertex, int subTaskIndex, IntermediateResult[] producedDataSets, Time timeout, long createTimestamp, int maxPriorExecutionHistoryLength, int initialAttemptCount) {
        this.jobVertex = jobVertex;
        this.subTaskIndex = subTaskIndex;
        this.executionVertexId = new ExecutionVertexID(jobVertex.getJobVertexId(), subTaskIndex);
        this.taskNameWithSubtask = String.format("%s (%d/%d)", jobVertex.getJobVertex().getName(), subTaskIndex + 1, jobVertex.getParallelism());
        this.resultPartitions = new LinkedHashMap<IntermediateResultPartitionID, IntermediateResultPartition>(producedDataSets.length, 1.0f);
        for (IntermediateResult result : producedDataSets) {
            IntermediateResultPartition irp = new IntermediateResultPartition(result, this, subTaskIndex, this.getExecutionGraphAccessor().getEdgeManager());
            result.setPartition(subTaskIndex, irp);
            this.resultPartitions.put(irp.getPartitionId(), irp);
        }
        this.priorExecutions = new EvictingBoundedList(maxPriorExecutionHistoryLength);
        this.currentExecution = new Execution(this.getExecutionGraphAccessor().getFutureExecutor(), this, initialAttemptCount, createTimestamp, timeout);
        this.getExecutionGraphAccessor().registerExecution(this.currentExecution);
        this.timeout = timeout;
        this.inputSplits = new ArrayList();
    }

    public JobID getJobId() {
        return this.jobVertex.getJobId();
    }

    public ExecutionJobVertex getJobVertex() {
        return this.jobVertex;
    }

    public JobVertexID getJobvertexId() {
        return this.jobVertex.getJobVertexId();
    }

    public String getTaskName() {
        return this.jobVertex.getJobVertex().getName();
    }

    @Override
    public String getTaskNameWithSubtaskIndex() {
        return this.taskNameWithSubtask;
    }

    public int getTotalNumberOfParallelSubtasks() {
        return this.jobVertex.getParallelism();
    }

    public int getMaxParallelism() {
        return this.jobVertex.getMaxParallelism();
    }

    public ResourceProfile getResourceProfile() {
        return this.jobVertex.getResourceProfile();
    }

    @Override
    public int getParallelSubtaskIndex() {
        return this.subTaskIndex;
    }

    public ExecutionVertexID getID() {
        return this.executionVertexId;
    }

    public int getNumberOfInputs() {
        return this.getAllConsumedPartitionGroups().size();
    }

    public List<ConsumedPartitionGroup> getAllConsumedPartitionGroups() {
        return this.getExecutionGraphAccessor().getEdgeManager().getConsumedPartitionGroupsForVertex(this.executionVertexId);
    }

    public ConsumedPartitionGroup getConsumedPartitionGroup(int input) {
        List<ConsumedPartitionGroup> allConsumedPartitions = this.getAllConsumedPartitionGroups();
        if (input < 0 || input >= allConsumedPartitions.size()) {
            throw new IllegalArgumentException(String.format("Input %d is out of range [0..%d)", input, allConsumedPartitions.size()));
        }
        return allConsumedPartitions.get(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSplit getNextInputSplit(String host) {
        int taskId = this.getParallelSubtaskIndex();
        ArrayList<InputSplit> arrayList = this.inputSplits;
        synchronized (arrayList) {
            InputSplit nextInputSplit = this.jobVertex.getSplitAssigner().getNextInputSplit(host, taskId);
            if (nextInputSplit != null) {
                this.inputSplits.add(nextInputSplit);
            }
            return nextInputSplit;
        }
    }

    @Override
    public Execution getCurrentExecutionAttempt() {
        return this.currentExecution;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.currentExecution.getState();
    }

    @Override
    public long getStateTimestamp(ExecutionState state) {
        return this.currentExecution.getStateTimestamp(state);
    }

    @Override
    public Optional<ErrorInfo> getFailureInfo() {
        return this.currentExecution.getFailureInfo();
    }

    public CompletableFuture<TaskManagerLocation> getCurrentTaskManagerLocationFuture() {
        return this.currentExecution.getTaskManagerLocationFuture();
    }

    public LogicalSlot getCurrentAssignedResource() {
        return this.currentExecution.getAssignedResource();
    }

    @Override
    public TaskManagerLocation getCurrentAssignedResourceLocation() {
        return this.currentExecution.getAssignedResourceLocation();
    }

    @Override
    @Nullable
    public ArchivedExecution getPriorExecutionAttempt(int attemptNumber) {
        EvictingBoundedList<ArchivedExecution> evictingBoundedList = this.priorExecutions;
        synchronized (evictingBoundedList) {
            if (attemptNumber >= 0 && attemptNumber < this.priorExecutions.size()) {
                return this.priorExecutions.get(attemptNumber);
            }
            throw new IllegalArgumentException("attempt does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchivedExecution getLatestPriorExecution() {
        EvictingBoundedList<ArchivedExecution> evictingBoundedList = this.priorExecutions;
        synchronized (evictingBoundedList) {
            int size = this.priorExecutions.size();
            if (size > 0) {
                return this.priorExecutions.get(size - 1);
            }
            return null;
        }
    }

    public TaskManagerLocation getLatestPriorLocation() {
        ArchivedExecution latestPriorExecution = this.getLatestPriorExecution();
        return latestPriorExecution != null ? latestPriorExecution.getAssignedResourceLocation() : null;
    }

    public AllocationID getLatestPriorAllocation() {
        ArchivedExecution latestPriorExecution = this.getLatestPriorExecution();
        return latestPriorExecution != null ? latestPriorExecution.getAssignedAllocationID() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EvictingBoundedList<ArchivedExecution> getCopyOfPriorExecutionsList() {
        EvictingBoundedList<ArchivedExecution> evictingBoundedList = this.priorExecutions;
        synchronized (evictingBoundedList) {
            return new EvictingBoundedList<ArchivedExecution>(this.priorExecutions);
        }
    }

    public final InternalExecutionGraphAccessor getExecutionGraphAccessor() {
        return this.jobVertex.getGraph();
    }

    public Map<IntermediateResultPartitionID, IntermediateResultPartition> getProducedPartitions() {
        return this.resultPartitions;
    }

    public void addConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitions) {
        this.getExecutionGraphAccessor().getEdgeManager().connectVertexWithConsumedPartitionGroup(this.executionVertexId, consumedPartitions);
    }

    public Optional<TaskManagerLocation> getPreferredLocationBasedOnState() {
        if (this.currentExecution.getTaskRestore() != null && this.currentExecution.getTaskRestore().getTaskStateSnapshot().hasState()) {
            return Optional.ofNullable(this.getLatestPriorLocation());
        }
        return Optional.empty();
    }

    public void resetForNewExecution() {
        this.resetForNewExecutionInternal(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetForNewExecutionInternal(long timestamp) {
        Execution oldExecution = this.currentExecution;
        ExecutionState oldState = oldExecution.getState();
        if (oldState.isTerminal()) {
            Execution newExecution;
            if (oldState == ExecutionState.FINISHED) {
                oldExecution.handlePartitionCleanup(false, true);
                this.getExecutionGraphAccessor().getPartitionGroupReleaseStrategy().vertexUnfinished(this.executionVertexId);
            }
            this.priorExecutions.add(oldExecution.archive());
            this.currentExecution = newExecution = new Execution(this.getExecutionGraphAccessor().getFutureExecutor(), this, oldExecution.getAttemptNumber() + 1, timestamp, this.timeout);
            ArrayList<InputSplit> arrayList = this.inputSplits;
            synchronized (arrayList) {
                InputSplitAssigner assigner = this.jobVertex.getSplitAssigner();
                if (assigner != null) {
                    assigner.returnInputSplit(this.inputSplits, this.getParallelSubtaskIndex());
                    this.inputSplits.clear();
                }
            }
            this.getExecutionGraphAccessor().registerExecution(newExecution);
            if (oldState == ExecutionState.FINISHED) {
                this.getJobVertex().executionVertexUnFinished();
            }
            for (IntermediateResultPartition resultPartition : this.resultPartitions.values()) {
                resultPartition.resetForNewExecution();
            }
        } else {
            throw new IllegalStateException("Cannot reset a vertex that is in non-terminal state " + (Object)((Object)oldState));
        }
    }

    public void tryAssignResource(LogicalSlot slot) {
        if (!this.currentExecution.tryAssignResource(slot)) {
            throw new IllegalStateException("Could not assign resource " + slot + " to current execution " + this.currentExecution + '.');
        }
    }

    public void deploy() throws JobException {
        this.currentExecution.deploy();
    }

    @VisibleForTesting
    public void deployToSlot(LogicalSlot slot) throws JobException {
        if (!this.currentExecution.tryAssignResource(slot)) {
            throw new IllegalStateException("Could not assign resource " + slot + " to current execution " + this.currentExecution + '.');
        }
        this.currentExecution.deploy();
    }

    public CompletableFuture<?> cancel() {
        Execution exec = this.currentExecution;
        exec.cancel();
        return exec.getReleaseFuture();
    }

    public CompletableFuture<?> suspend() {
        return this.currentExecution.suspend();
    }

    public void fail(Throwable t) {
        this.currentExecution.fail(t);
    }

    public void markFailed(Throwable t) {
        this.currentExecution.markFailed(t);
    }

    void notifyPartitionDataAvailable(ResultPartitionID partitionId) {
        Preconditions.checkArgument((boolean)partitionId.getProducerId().equals(this.currentExecution.getAttemptId()));
        IntermediateResultPartition partition = this.resultPartitions.get(partitionId.getPartitionId());
        Preconditions.checkState((partition != null ? 1 : 0) != 0, (Object)("Unknown partition " + partitionId + "."));
        Preconditions.checkState((boolean)partition.getResultType().isPipelined(), (Object)"partition data available notification is only valid for pipelined partitions.");
        partition.markDataProduced();
    }

    void cachePartitionInfo(PartitionInfo partitionInfo) {
        this.getCurrentExecutionAttempt().cachePartitionInfo(partitionInfo);
    }

    @VisibleForTesting
    public List<IntermediateResultPartition> finishAllBlockingPartitions() {
        LinkedList<IntermediateResultPartition> finishedBlockingPartitions = null;
        for (IntermediateResultPartition partition : this.resultPartitions.values()) {
            if (!partition.getResultType().isBlocking()) continue;
            partition.markFinished();
            if (finishedBlockingPartitions == null) {
                finishedBlockingPartitions = new LinkedList<IntermediateResultPartition>();
            }
            finishedBlockingPartitions.add(partition);
        }
        if (finishedBlockingPartitions == null) {
            return Collections.emptyList();
        }
        return finishedBlockingPartitions;
    }

    void executionFinished(Execution execution) {
        this.getJobVertex().executionVertexFinished();
    }

    void notifyPendingDeployment(Execution execution) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraphAccessor().getExecutionDeploymentListener().onStartedDeployment(execution.getAttemptId(), execution.getAssignedResourceLocation().getResourceID());
        }
    }

    void notifyCompletedDeployment(Execution execution) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraphAccessor().getExecutionDeploymentListener().onCompletedDeployment(execution.getAttemptId());
        }
    }

    void notifyStateTransition(Execution execution, ExecutionState newState) {
        if (this.isCurrentExecution(execution)) {
            this.getExecutionGraphAccessor().notifyExecutionChange(execution, newState);
        }
    }

    private boolean isCurrentExecution(Execution execution) {
        return this.currentExecution == execution;
    }

    public String toString() {
        return this.getTaskNameWithSubtaskIndex();
    }

    public ArchivedExecutionVertex archive() {
        return new ArchivedExecutionVertex(this);
    }
}

