/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.util.Preconditions;

public class InputGateWithMetrics
extends IndexedInputGate {
    private final IndexedInputGate inputGate;
    private final Counter numBytesIn;

    public InputGateWithMetrics(IndexedInputGate inputGate, Counter numBytesIn) {
        this.inputGate = (IndexedInputGate)Preconditions.checkNotNull((Object)inputGate);
        this.numBytesIn = (Counter)Preconditions.checkNotNull((Object)numBytesIn);
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        return this.inputGate.getAvailableFuture();
    }

    @Override
    public void resumeConsumption(InputChannelInfo channelInfo) throws IOException {
        this.inputGate.resumeConsumption(channelInfo);
    }

    @Override
    public void acknowledgeAllRecordsProcessed(InputChannelInfo channelInfo) throws IOException {
        this.inputGate.acknowledgeAllRecordsProcessed(channelInfo);
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.inputGate.getNumberOfInputChannels();
    }

    @Override
    public InputChannel getChannel(int channelIndex) {
        return this.inputGate.getChannel(channelIndex);
    }

    @Override
    public int getGateIndex() {
        return this.inputGate.getGateIndex();
    }

    @Override
    public List<InputChannelInfo> getUnfinishedChannels() {
        return this.inputGate.getUnfinishedChannels();
    }

    @Override
    public void triggerDebloating() {
        this.inputGate.triggerDebloating();
    }

    @Override
    public boolean isFinished() {
        return this.inputGate.isFinished();
    }

    @Override
    public boolean hasReceivedEndOfData() {
        return this.inputGate.hasReceivedEndOfData();
    }

    @Override
    public void setup() throws IOException {
        this.inputGate.setup();
    }

    @Override
    public CompletableFuture<Void> getStateConsumedFuture() {
        return this.inputGate.getStateConsumedFuture();
    }

    @Override
    public void requestPartitions() throws IOException {
        this.inputGate.requestPartitions();
    }

    @Override
    public void setChannelStateWriter(ChannelStateWriter channelStateWriter) {
        this.inputGate.setChannelStateWriter(channelStateWriter);
    }

    @Override
    public Optional<BufferOrEvent> getNext() throws IOException, InterruptedException {
        return this.inputGate.getNext().map(this::updateMetrics);
    }

    @Override
    public Optional<BufferOrEvent> pollNext() throws IOException, InterruptedException {
        return this.inputGate.pollNext().map(this::updateMetrics);
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        this.inputGate.sendTaskEvent(event);
    }

    @Override
    public void close() throws Exception {
        this.inputGate.close();
    }

    @Override
    public CompletableFuture<?> getPriorityEventAvailableFuture() {
        return this.inputGate.getPriorityEventAvailableFuture();
    }

    @Override
    public void finishReadRecoveredState() throws IOException {
        this.inputGate.finishReadRecoveredState();
    }

    private BufferOrEvent updateMetrics(BufferOrEvent bufferOrEvent) {
        int incomingDataSize = bufferOrEvent.getSize();
        this.numBytesIn.inc((long)incomingDataSize);
        return bufferOrEvent;
    }
}

