/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapSavepointStore
implements SavepointStore {
    private static final Logger LOG = LoggerFactory.getLogger(HeapSavepointStore.class);
    private final Object shutDownLock = new Object();
    private final Map<String, Savepoint> savepoints = new HashMap<String, Savepoint>(1);
    private final AtomicInteger currentId = new AtomicInteger();
    private boolean shutDown;
    private final Thread shutdownHook = new Thread(new Runnable(){

        @Override
        public void run() {
            try {
                HeapSavepointStore.this.shutdown();
            }
            catch (Throwable t) {
                LOG.warn("Failure during shut down hook.", t);
            }
        }
    });

    public HeapSavepointStore() {
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable t) {
            LOG.warn("Failed to register shutdown hook.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Savepoint> String storeSavepoint(T savepoint) throws IOException {
        Preconditions.checkNotNull(savepoint, (String)"Savepoint");
        Object object = this.shutDownLock;
        synchronized (object) {
            if (this.shutDown) {
                throw new IllegalStateException("Shut down");
            }
            String path = "jobmanager://savepoints/" + this.currentId.incrementAndGet();
            this.savepoints.put(path, savepoint);
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint loadSavepoint(String path) throws IOException {
        Savepoint savepoint;
        Preconditions.checkNotNull((Object)path, (String)"Path");
        Object object = this.shutDownLock;
        synchronized (object) {
            savepoint = this.savepoints.get(path);
        }
        if (savepoint != null) {
            return savepoint;
        }
        throw new IllegalArgumentException("Invalid path '" + path + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeSavepoint(String path, ClassLoader classLoader) throws Exception {
        Savepoint savepoint;
        Preconditions.checkNotNull((Object)path, (String)"Path");
        Preconditions.checkNotNull((Object)classLoader, (String)"Class loader");
        Object object = this.shutDownLock;
        synchronized (object) {
            savepoint = this.savepoints.remove(path);
        }
        if (savepoint == null) {
            throw new IllegalArgumentException("Invalid path '" + path + "'.");
        }
        savepoint.dispose(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws Exception {
        Object object = this.shutDownLock;
        synchronized (object) {
            for (Savepoint savepoint : this.savepoints.values()) {
                try {
                    savepoint.dispose(ClassLoader.getSystemClassLoader());
                }
                catch (Throwable t) {
                    LOG.warn("Failed to dispose savepoint " + savepoint.getCheckpointId(), t);
                }
            }
            this.savepoints.clear();
            if (this.shutdownHook != null && this.shutdownHook != Thread.currentThread()) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Throwable t) {
                    LOG.warn("Failed to unregister shut down hook.");
                }
            }
            this.shutDown = true;
        }
    }
}

