/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.fs.FSDataOutputStream;

public class HadoopDataOutputStream
extends org.apache.flink.core.fs.FSDataOutputStream {
    private final FSDataOutputStream fdos;
    private static final Method HFLUSH_METHOD;
    private static final Method HSYNC_METHOD;
    private static final Throwable HFLUSH_ERROR;
    private static final Throwable HSYNC_ERROR;

    public HadoopDataOutputStream(FSDataOutputStream fdos) {
        if (fdos == null) {
            throw new NullPointerException();
        }
        this.fdos = fdos;
    }

    public void write(int b) throws IOException {
        this.fdos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fdos.write(b, off, len);
    }

    public void close() throws IOException {
        this.fdos.close();
    }

    public void flush() throws IOException {
        if (HFLUSH_METHOD != null) {
            try {
                HFLUSH_METHOD.invoke((Object)this.fdos, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new IOException("Exception while invoking hflush()", cause);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Cannot invoke hflush()", e);
            }
        } else {
            if (HFLUSH_ERROR != null) {
                if (HFLUSH_ERROR instanceof NoSuchMethodException) {
                    throw new UnsupportedOperationException("hflush() method is not available in this version of Hadoop.");
                }
                throw new IOException("Cannot access hflush() method", HFLUSH_ERROR);
            }
            throw new UnsupportedOperationException("hflush() is not available in this version of Hadoop.");
        }
    }

    public void sync() throws IOException {
        if (HSYNC_METHOD != null) {
            try {
                HSYNC_METHOD.invoke((Object)this.fdos, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new IOException("Exception while invoking hsync()", cause);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Cannot invoke hsync()", e);
            }
        } else {
            if (HSYNC_ERROR != null) {
                if (HSYNC_ERROR instanceof NoSuchMethodException) {
                    throw new UnsupportedOperationException("hsync() method is not available in this version of Hadoop.");
                }
                throw new IOException("Cannot access hsync() method", HSYNC_ERROR);
            }
            throw new UnsupportedOperationException("hsync() is not available in this version of Hadoop.");
        }
    }

    public FSDataOutputStream getHadoopOutputStream() {
        return this.fdos;
    }

    static {
        Method hflush = null;
        Method hsync = null;
        Throwable flushError = null;
        Throwable syncError = null;
        try {
            hflush = FSDataOutputStream.class.getMethod("hflush", new Class[0]);
        }
        catch (Throwable t) {
            flushError = t;
        }
        try {
            hsync = FSDataOutputStream.class.getMethod("hsync", new Class[0]);
        }
        catch (Throwable t) {
            syncError = t;
        }
        HFLUSH_METHOD = hflush;
        HSYNC_METHOD = hsync;
        HFLUSH_ERROR = flushError;
        HSYNC_ERROR = syncError;
    }
}

