/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatMapDriver<IT, OT>
implements Driver<FlatMapFunction<IT, OT>, OT> {
    private static final Logger LOG = LoggerFactory.getLogger(FlatMapDriver.class);
    private TaskContext<FlatMapFunction<IT, OT>, OT> taskContext;
    private volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<FlatMapFunction<IT, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<FlatMapFunction<IT, OT>> getStubType() {
        Class<FlatMapFunction> clazz = FlatMapFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() {
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("FlatMapDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
    }

    @Override
    public void run() throws Exception {
        Counter numRecordsIn = this.taskContext.getMetricGroup().counter("numRecordsIn");
        Counter numRecordsOut = this.taskContext.getMetricGroup().counter("numRecordsOut");
        MutableObjectIterator input = this.taskContext.getInput(0);
        FlatMapFunction<IT, OT> function = this.taskContext.getStub();
        CountingCollector<OT> output = new CountingCollector<OT>(this.taskContext.getOutputCollector(), numRecordsOut);
        if (this.objectReuseEnabled) {
            Object record = this.taskContext.getInputSerializer(0).getSerializer().createInstance();
            while (this.running && (record = input.next(record)) != null) {
                numRecordsIn.inc();
                function.flatMap(record, output);
            }
        } else {
            Object record;
            while (this.running && (record = input.next()) != null) {
                numRecordsIn.inc();
                function.flatMap(record, output);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

