/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.runtime.operators.util.metrics.CountingMutableObjectIterator;
import org.apache.flink.runtime.util.NonReusingMutableToRegularIteratorWrapper;
import org.apache.flink.runtime.util.ReusingMutableToRegularIteratorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPartitionDriver<IT, OT>
implements Driver<MapPartitionFunction<IT, OT>, OT> {
    private static final Logger LOG = LoggerFactory.getLogger(MapPartitionDriver.class);
    private TaskContext<MapPartitionFunction<IT, OT>, OT> taskContext;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<MapPartitionFunction<IT, OT>, OT> context) {
        this.taskContext = context;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<MapPartitionFunction<IT, OT>> getStubType() {
        Class<MapPartitionFunction> clazz = MapPartitionFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 0;
    }

    @Override
    public void prepare() {
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("MapPartitionDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
    }

    @Override
    public void run() throws Exception {
        Counter numRecordsIn = this.taskContext.getMetricGroup().counter("numRecordsIn");
        Counter numRecordsOut = this.taskContext.getMetricGroup().counter("numRecordsOut");
        CountingMutableObjectIterator input = new CountingMutableObjectIterator(this.taskContext.getInput(0), numRecordsIn);
        MapPartitionFunction<IT, OT> function = this.taskContext.getStub();
        CountingCollector<OT> output = new CountingCollector<OT>(this.taskContext.getOutputCollector(), numRecordsOut);
        if (this.objectReuseEnabled) {
            ReusingMutableToRegularIteratorWrapper inIter = new ReusingMutableToRegularIteratorWrapper(input, this.taskContext.getInputSerializer(0).getSerializer());
            function.mapPartition(inIter, output);
        } else {
            NonReusingMutableToRegularIteratorWrapper inIter = new NonReusingMutableToRegularIteratorWrapper(input, this.taskContext.getInputSerializer(0).getSerializer());
            function.mapPartition(inIter, output);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
    }
}

