/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.chaining;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.chaining.ChainedDriver;
import org.apache.flink.runtime.operators.chaining.ExceptionInChainedStubException;
import org.apache.flink.runtime.operators.hash.InPlaceMutableHashTable;
import org.apache.flink.runtime.operators.sort.FixedLengthRecordSorter;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.NormalizedKeySorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedReduceCombineDriver<T>
extends ChainedDriver<T, T> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainedReduceCombineDriver.class);
    private static final int THRESHOLD_FOR_IN_PLACE_SORTING = 32;
    private AbstractInvokable parent;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> comparator;
    private ReduceFunction<T> reducer;
    private DriverStrategy strategy;
    private InMemorySorter<T> sorter;
    private QuickSort sortAlgo = new QuickSort();
    private InPlaceMutableHashTable<T> table;
    private InPlaceMutableHashTable.ReduceFacade reduceFacade;
    private List<MemorySegment> memory;
    private volatile boolean running;

    @Override
    public Function getStub() {
        return this.reducer;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void setup(AbstractInvokable parent) {
        this.parent = parent;
        this.running = true;
        this.strategy = this.config.getDriverStrategy();
        this.reducer = BatchTask.instantiateUserCode(this.config, this.userCodeClassLoader, ReduceFunction.class);
        FunctionUtils.setFunctionRuntimeContext(this.reducer, (RuntimeContext)this.getUdfRuntimeContext());
    }

    @Override
    public void openTask() throws Exception {
        Configuration stubConfig = this.config.getStubParameters();
        BatchTask.openUserCode(this.reducer, stubConfig);
        this.serializer = this.config.getInputSerializer(0, this.userCodeClassLoader).getSerializer();
        this.comparator = this.config.getDriverComparator(0, this.userCodeClassLoader).createComparator();
        MemoryManager memManager = this.parent.getEnvironment().getMemoryManager();
        int numMemoryPages = memManager.computeNumberOfPages(this.config.getRelativeMemoryDriver());
        this.memory = memManager.allocatePages(this.parent, numMemoryPages);
        LOG.debug("ChainedReduceCombineDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        switch (this.strategy) {
            case SORTED_PARTIAL_REDUCE: {
                if (this.comparator.supportsSerializationWithKeyNormalization() && this.serializer.getLength() > 0 && this.serializer.getLength() <= 32) {
                    this.sorter = new FixedLengthRecordSorter<T>(this.serializer, this.comparator.duplicate(), this.memory);
                    break;
                }
                this.sorter = new NormalizedKeySorter<T>(this.serializer, this.comparator.duplicate(), this.memory);
                break;
            }
            case HASHED_PARTIAL_REDUCE: {
                this.table = new InPlaceMutableHashTable<T>(this.serializer, this.comparator, this.memory);
                this.table.open();
                InPlaceMutableHashTable<T> inPlaceMutableHashTable = this.table;
                inPlaceMutableHashTable.getClass();
                this.reduceFacade = new InPlaceMutableHashTable.ReduceFacade(inPlaceMutableHashTable, this.reducer, this.outputCollector, this.objectReuseEnabled);
            }
        }
    }

    @Override
    public void collect(T record) {
        try {
            switch (this.strategy) {
                case SORTED_PARTIAL_REDUCE: {
                    this.collectSorted(record);
                    break;
                }
                case HASHED_PARTIAL_REDUCE: {
                    this.collectHashed(record);
                }
            }
        }
        catch (Exception ex) {
            throw new ExceptionInChainedStubException(this.taskName, ex);
        }
    }

    private void collectSorted(T record) throws Exception {
        if (!this.sorter.write(record)) {
            this.sortAndCombine();
            this.sorter.reset();
            if (!this.sorter.write(record)) {
                throw new IOException("Cannot write record to fresh sort buffer. Record too large.");
            }
        }
    }

    private void collectHashed(T record) throws Exception {
        try {
            this.reduceFacade.updateTableEntryWithReduce(record);
        }
        catch (EOFException ex) {
            this.reduceFacade.emitAndReset();
            this.reduceFacade.updateTableEntryWithReduce(record);
        }
    }

    private void sortAndCombine() throws Exception {
        block6: {
            InMemorySorter<T> sorter = this.sorter;
            if (sorter.isEmpty()) break block6;
            this.sortAlgo.sort(sorter);
            TypeSerializer<T> serializer = this.serializer;
            TypeComparator<T> comparator = this.comparator;
            ReduceFunction<T> function = this.reducer;
            Collector output = this.outputCollector;
            MutableObjectIterator<T> input = sorter.getIterator();
            if (this.objectReuseEnabled) {
                Object reuse1 = input.next();
                Object reuse2 = serializer.createInstance();
                Object value = reuse1;
                while (this.running && value != null) {
                    Object tmp;
                    comparator.setReference(value);
                    while ((reuse2 = input.next(reuse2)) != null && comparator.equalToReference(reuse2)) {
                        if ((value = function.reduce(value, reuse2)) != reuse2) continue;
                        tmp = reuse1;
                        reuse1 = reuse2;
                        reuse2 = tmp;
                    }
                    output.collect(value);
                    tmp = reuse1;
                    reuse1 = reuse2;
                    reuse2 = tmp;
                    value = reuse1;
                }
            } else {
                Object value = input.next();
                while (this.running && value != null) {
                    comparator.setReference(value);
                    Object res = value;
                    while ((value = input.next()) != null && comparator.equalToReference(value)) {
                        res = function.reduce(res, value);
                    }
                    output.collect(res);
                }
            }
        }
    }

    public void close() {
        try {
            switch (this.strategy) {
                case SORTED_PARTIAL_REDUCE: {
                    this.sortAndCombine();
                    break;
                }
                case HASHED_PARTIAL_REDUCE: {
                    this.reduceFacade.emit();
                }
            }
        }
        catch (Exception ex2) {
            throw new ExceptionInChainedStubException(this.taskName, ex2);
        }
        this.outputCollector.close();
    }

    @Override
    public void closeTask() throws Exception {
        if (this.sorter != null) {
            this.sorter.dispose();
        }
        if (this.table != null) {
            this.table.close();
        }
        this.parent.getEnvironment().getMemoryManager().release(this.memory);
        BatchTask.closeUserCode(this.reducer);
    }

    @Override
    public void cancelTask() {
        this.running = false;
        try {
            if (this.sorter != null) {
                this.sorter.dispose();
            }
            if (this.table != null) {
                this.table.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.getEnvironment().getMemoryManager().release(this.memory);
    }
}

