/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.util.Preconditions;

public class BloomFilter {
    protected BitSet bitSet;
    protected int expectedEntries;
    protected int numHashFunctions;

    public BloomFilter(int expectedEntries, int byteSize) {
        Preconditions.checkArgument((expectedEntries > 0 ? 1 : 0) != 0, (Object)"expectedEntries should be > 0");
        this.expectedEntries = expectedEntries;
        this.numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedEntries, byteSize << 3);
        this.bitSet = new BitSet(byteSize);
    }

    public void setBitsLocation(MemorySegment memorySegment, int offset) {
        this.bitSet.setMemorySegment(memorySegment, offset);
    }

    public static int optimalNumOfBits(long inputEntries, double fpp) {
        int numBits = (int)((double)(-inputEntries) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
        return numBits;
    }

    public static double estimateFalsePositiveProbability(long inputEntries, int bitSize) {
        int numFunction = BloomFilter.optimalNumOfHashFunctions(inputEntries, bitSize);
        double p = Math.pow(Math.E, -((double)numFunction) * (double)inputEntries / (double)bitSize);
        double estimatedFPP = Math.pow(1.0 - p, numFunction);
        return estimatedFPP;
    }

    static int optimalNumOfHashFunctions(long expectEntries, long bitSize) {
        return Math.max(1, (int)Math.round((double)bitSize / (double)expectEntries * Math.log(2.0)));
    }

    public void addHash(int hash32) {
        int hash1 = hash32;
        int hash2 = hash32 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.bitSet.bitSize();
            this.bitSet.set(pos);
        }
    }

    public boolean testHash(int hash32) {
        int hash1 = hash32;
        int hash2 = hash32 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.bitSet.bitSize())) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.bitSet.clear();
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("BloomFilter:\n");
        output.append("\thash function number:").append(this.numHashFunctions).append("\n");
        output.append(this.bitSet);
        return output.toString();
    }

    public class BitSet {
        private MemorySegment memorySegment;
        private int offset;
        private int length;
        private final int LONG_POSITION_MASK = -64;

        public BitSet(int byteSize) {
            Preconditions.checkArgument((byteSize > 0 ? 1 : 0) != 0, (Object)"bits size should be greater than 0.");
            Preconditions.checkArgument((byteSize << 29 == 0 ? 1 : 0) != 0, (Object)"bytes size should be integral multiple of long size(8 Bytes).");
            this.length = byteSize;
        }

        public void setMemorySegment(MemorySegment memorySegment, int offset) {
            this.memorySegment = memorySegment;
            this.offset = offset;
        }

        public void set(int index) {
            int longIndex = (index & 0xFFFFFFC0) >>> 3;
            long current = this.memorySegment.getLong(this.offset + longIndex);
            this.memorySegment.putLong(this.offset + longIndex, current |= 1L << index);
        }

        public boolean get(int index) {
            int longIndex = (index & 0xFFFFFFC0) >>> 3;
            long current = this.memorySegment.getLong(this.offset + longIndex);
            return (current & 1L << index) != 0L;
        }

        public int bitSize() {
            return this.length << 3;
        }

        public MemorySegment getMemorySegment() {
            return this.memorySegment;
        }

        public void clear() {
            long zeroValue = 0L;
            for (int i = 0; i < this.length / 8; ++i) {
                this.memorySegment.putLong(this.offset + i * 8, zeroValue);
            }
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            output.append("BitSet:\n");
            output.append("\tMemorySegment:").append(this.memorySegment.size()).append("\n");
            output.append("\tOffset:").append(this.offset).append("\n");
            output.append("\tLength:").append(this.length).append("\n");
            return output.toString();
        }
    }
}

