/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;

public abstract class AbstractFsStateSnapshot<K, N, SV, S extends State, SD extends StateDescriptor<S, ?>>
extends AbstractFileStateHandle
implements KvStateSnapshot<K, N, S, SD, FsStateBackend> {
    private static final long serialVersionUID = 1L;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<N> namespaceSerializer;
    protected final TypeSerializer<SV> stateSerializer;
    protected final SD stateDesc;

    public AbstractFsStateSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> stateSerializer, SD stateDesc, Path filePath) {
        super(filePath);
        this.stateDesc = stateDesc;
        this.keySerializer = keySerializer;
        this.stateSerializer = stateSerializer;
        this.namespaceSerializer = namespaceSerializer;
    }

    public abstract KvState<K, N, S, SD, FsStateBackend> createFsState(FsStateBackend var1, HashMap<N, Map<K, SV>> var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KvState<K, N, S, SD, FsStateBackend> restoreState(FsStateBackend stateBackend, TypeSerializer<K> keySerializer, ClassLoader classLoader) throws Exception {
        if (!this.keySerializer.equals(keySerializer)) {
            throw new IllegalArgumentException("Cannot restore the state from the snapshot with the given serializers. State (K/V) was serialized with (" + this.keySerializer + ") " + "now is (" + keySerializer + ")");
        }
        this.ensureNotClosed();
        try (FSDataInputStream inStream = stateBackend.getFileSystem().open(this.getFilePath());){
            this.registerCloseable((Closeable)inStream);
            DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper((InputStream)inStream);
            int numKeys = inView.readInt();
            HashMap stateMap = new HashMap(numKeys);
            for (int i = 0; i < numKeys; ++i) {
                Object namespace = this.namespaceSerializer.deserialize((DataInputView)inView);
                int numValues = inView.readInt();
                HashMap<Object, Object> namespaceMap = new HashMap<Object, Object>(numValues);
                stateMap.put(namespace, namespaceMap);
                for (int j = 0; j < numValues; ++j) {
                    Object key = keySerializer.deserialize((DataInputView)inView);
                    Object value = this.stateSerializer.deserialize((DataInputView)inView);
                    namespaceMap.put(key, value);
                }
            }
            KvState kvState = this.createFsState(stateBackend, stateMap);
            return kvState;
        }
        catch (Exception e) {
            throw new Exception("Failed to restore state from file system", e);
        }
    }

    @Override
    public long getStateSize() throws IOException {
        return this.getFileSize();
    }
}

