/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper.filesystem;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.filesystem.FileSerializableStateHandle;
import org.apache.flink.runtime.zookeeper.StateStorageHelper;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

public class FileSystemStateStorageHelper<T extends Serializable>
implements StateStorageHelper<T> {
    private final Path rootPath;
    private final String prefix;
    private final FileSystem fs;

    public FileSystemStateStorageHelper(String rootPath, String prefix) throws IOException {
        this(new Path(rootPath), prefix);
    }

    public FileSystemStateStorageHelper(Path rootPath, String prefix) throws IOException {
        this.rootPath = (Path)Preconditions.checkNotNull((Object)rootPath, (String)"Root path");
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (String)"Prefix");
        this.fs = FileSystem.get((URI)rootPath.toUri());
    }

    @Override
    public StateHandle<T> store(T state) throws Exception {
        Exception latestException = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            FSDataOutputStream outStream;
            Path filePath = this.getNewFilePath();
            try {
                outStream = this.fs.create(filePath, false);
            }
            catch (Exception e) {
                latestException = e;
                continue;
            }
            try (ObjectOutputStream os = new ObjectOutputStream((OutputStream)outStream);){
                os.writeObject(state);
            }
            return new FileSerializableStateHandle(filePath);
        }
        throw new Exception("Could not open output stream for state backend", latestException);
    }

    private Path getNewFilePath() {
        return new Path(this.rootPath, FileUtils.getRandomFilename((String)this.prefix));
    }
}

