/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.util.Preconditions;

public class CheckpointStatsHistory
implements Serializable {
    private static final long serialVersionUID = 7090320677606528415L;
    private final Iterable<AbstractCheckpointStats> checkpointsIterable;
    private final Map<Long, AbstractCheckpointStats> checkpointsById;
    private final int maxSize;
    private final boolean readOnly;
    private transient AbstractCheckpointStats[] checkpointsArray;
    private transient int nextPos;
    @Nullable
    private CompletedCheckpointStats latestCompletedCheckpoint;
    @Nullable
    private FailedCheckpointStats latestFailedCheckpoint;
    @Nullable
    private CompletedCheckpointStats latestSavepoint;

    CheckpointStatsHistory(int maxSize) {
        this(false, maxSize, new AbstractCheckpointStats[0], Collections.emptyList(), Collections.emptyMap(), null, null, null);
    }

    private CheckpointStatsHistory(boolean readOnly, int maxSize, AbstractCheckpointStats[] checkpointArray, Iterable<AbstractCheckpointStats> checkpointsIterable, Map<Long, AbstractCheckpointStats> checkpointsById, CompletedCheckpointStats latestCompletedCheckpoint, FailedCheckpointStats latestFailedCheckpoint, CompletedCheckpointStats latestSavepoint) {
        this.readOnly = readOnly;
        Preconditions.checkArgument((maxSize >= 0 ? 1 : 0) != 0, (Object)"Negative maximum size");
        this.maxSize = maxSize;
        this.checkpointsArray = checkpointArray;
        this.checkpointsIterable = (Iterable)Preconditions.checkNotNull(checkpointsIterable);
        this.checkpointsById = (Map)Preconditions.checkNotNull(checkpointsById);
        this.latestCompletedCheckpoint = latestCompletedCheckpoint;
        this.latestFailedCheckpoint = latestFailedCheckpoint;
        this.latestSavepoint = latestSavepoint;
    }

    public Iterable<AbstractCheckpointStats> getCheckpoints() {
        return this.checkpointsIterable;
    }

    public AbstractCheckpointStats getCheckpointById(long checkpointId) {
        return this.checkpointsById.get(checkpointId);
    }

    @Nullable
    public CompletedCheckpointStats getLatestCompletedCheckpoint() {
        return this.latestCompletedCheckpoint;
    }

    @Nullable
    public FailedCheckpointStats getLatestFailedCheckpoint() {
        return this.latestFailedCheckpoint;
    }

    @Nullable
    public CompletedCheckpointStats getLatestSavepoint() {
        return this.latestSavepoint;
    }

    CheckpointStatsHistory createSnapshot() {
        Iterable<Object> checkpointsIterable;
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create a snapshot of a read-only history.");
        }
        HashMap<Long, AbstractCheckpointStats> checkpointsById = new HashMap<Long, AbstractCheckpointStats>(this.checkpointsArray.length);
        if (this.maxSize == 0) {
            checkpointsIterable = Collections.emptyList();
        } else {
            checkpointsIterable = new CheckpointsStatsHistoryIterable(this.checkpointsArray, this.nextPos);
            for (AbstractCheckpointStats abstractCheckpointStats : checkpointsIterable) {
                checkpointsById.put(abstractCheckpointStats.getCheckpointId(), abstractCheckpointStats);
            }
        }
        if (this.latestCompletedCheckpoint != null) {
            checkpointsById.put(this.latestCompletedCheckpoint.getCheckpointId(), this.latestCompletedCheckpoint);
        }
        if (this.latestFailedCheckpoint != null) {
            checkpointsById.put(this.latestFailedCheckpoint.getCheckpointId(), this.latestFailedCheckpoint);
        }
        if (this.latestSavepoint != null) {
            checkpointsById.put(this.latestSavepoint.getCheckpointId(), this.latestSavepoint);
        }
        return new CheckpointStatsHistory(true, this.maxSize, null, checkpointsIterable, checkpointsById, this.latestCompletedCheckpoint, this.latestFailedCheckpoint, this.latestSavepoint);
    }

    void addInProgressCheckpoint(PendingCheckpointStats pending) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create a snapshot of a read-only history.");
        }
        if (this.maxSize == 0) {
            return;
        }
        Preconditions.checkNotNull((Object)pending, (String)"Pending checkpoint");
        if (this.checkpointsArray.length < this.maxSize) {
            this.checkpointsArray = Arrays.copyOf(this.checkpointsArray, this.checkpointsArray.length + 1);
        }
        if (this.nextPos == this.checkpointsArray.length) {
            this.nextPos = 0;
        }
        this.checkpointsArray[this.nextPos++] = pending;
    }

    boolean replacePendingCheckpointById(AbstractCheckpointStats completedOrFailed) {
        int startPos;
        int i;
        Preconditions.checkArgument((!completedOrFailed.getStatus().isInProgress() ? 1 : 0) != 0, (Object)"Not allowed to replace with in progress checkpoints.");
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create a snapshot of a read-only history.");
        }
        if (completedOrFailed.getStatus().isCompleted()) {
            CompletedCheckpointStats completed = (CompletedCheckpointStats)completedOrFailed;
            if (CheckpointProperties.isSavepoint(completed.getProperties()) && (this.latestSavepoint == null || completed.getCheckpointId() > this.latestSavepoint.getCheckpointId())) {
                this.latestSavepoint = completed;
            } else if (this.latestCompletedCheckpoint == null || completed.getCheckpointId() > this.latestCompletedCheckpoint.getCheckpointId()) {
                this.latestCompletedCheckpoint = completed;
            }
        } else if (completedOrFailed.getStatus().isFailed()) {
            FailedCheckpointStats failed = (FailedCheckpointStats)completedOrFailed;
            if (this.latestFailedCheckpoint == null || failed.getCheckpointId() > this.latestFailedCheckpoint.getCheckpointId()) {
                this.latestFailedCheckpoint = failed;
            }
        }
        if (this.maxSize == 0) {
            return false;
        }
        long checkpointId = completedOrFailed.getCheckpointId();
        for (i = startPos = this.nextPos == this.checkpointsArray.length ? this.checkpointsArray.length - 1 : this.nextPos - 1; i >= 0; --i) {
            if (this.checkpointsArray[i].getCheckpointId() != checkpointId) continue;
            this.checkpointsArray[i] = completedOrFailed;
            return true;
        }
        for (i = this.checkpointsArray.length - 1; i > startPos; --i) {
            if (this.checkpointsArray[i].getCheckpointId() != checkpointId) continue;
            this.checkpointsArray[i] = completedOrFailed;
            return true;
        }
        return false;
    }

    private static class CheckpointsStatsHistoryIterable
    implements Iterable<AbstractCheckpointStats>,
    Serializable {
        private static final long serialVersionUID = 726376482426055490L;
        private final AbstractCheckpointStats[] checkpointsArray;
        private final int startPos;

        CheckpointsStatsHistoryIterable(AbstractCheckpointStats[] checkpointsArray, int nextPos) {
            this.checkpointsArray = Arrays.copyOf(checkpointsArray, checkpointsArray.length);
            this.startPos = nextPos == checkpointsArray.length ? checkpointsArray.length - 1 : nextPos - 1;
        }

        @Override
        public Iterator<AbstractCheckpointStats> iterator() {
            return new CheckpointsSnapshotIterator();
        }

        private class CheckpointsSnapshotIterator
        implements Iterator<AbstractCheckpointStats> {
            private int currentPos;
            private int remaining;

            CheckpointsSnapshotIterator() {
                this.currentPos = CheckpointsStatsHistoryIterable.this.startPos;
                this.remaining = CheckpointsStatsHistoryIterable.this.checkpointsArray.length;
            }

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            @Override
            public AbstractCheckpointStats next() {
                if (this.hasNext()) {
                    AbstractCheckpointStats stats = CheckpointsStatsHistoryIterable.this.checkpointsArray[this.currentPos--];
                    if (this.currentPos == -1) {
                        this.currentPos = CheckpointsStatsHistoryIterable.this.checkpointsArray.length - 1;
                    }
                    --this.remaining;
                    return stats;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

