/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;

public class ResourceProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ResourceProfile UNKNOWN = new ResourceProfile(-1.0, -1L);
    private final double cpuCores;
    private final long memoryInMB;

    public ResourceProfile(double cpuCores, long memoryInMB) {
        this.cpuCores = cpuCores;
        this.memoryInMB = memoryInMB;
    }

    public ResourceProfile(ResourceProfile other) {
        this.cpuCores = other.cpuCores;
        this.memoryInMB = other.memoryInMB;
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public long getMemoryInMB() {
        return this.memoryInMB;
    }

    public boolean isMatching(ResourceProfile required) {
        return this.cpuCores >= required.getCpuCores() && this.memoryInMB >= required.getMemoryInMB();
    }

    public int hashCode() {
        long cpuBits = Double.doubleToLongBits(this.cpuCores);
        return (int)(cpuBits ^ cpuBits >>> 32 ^ this.memoryInMB ^ this.memoryInMB >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceProfile.class) {
            ResourceProfile that = (ResourceProfile)obj;
            return this.cpuCores == that.cpuCores && this.memoryInMB == that.memoryInMB;
        }
        return false;
    }

    public String toString() {
        return "ResourceProfile{cpuCores=" + this.cpuCores + ", memoryInMB=" + this.memoryInMB + '}';
    }
}

