/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.java.hadoop.mapred.utils.HadoopUtils;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopModule
implements SecurityModule {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopModule.class);
    UserGroupInformation loginUser;

    @Override
    public void install(SecurityUtils.SecurityConfiguration securityConfig) throws SecurityModule.SecurityInstallException {
        UserGroupInformation.setConfiguration((Configuration)securityConfig.getHadoopConfiguration());
        try {
            if (UserGroupInformation.isSecurityEnabled() && !StringUtils.isBlank((CharSequence)securityConfig.getKeytab()) && !StringUtils.isBlank((CharSequence)securityConfig.getPrincipal())) {
                String keytabPath = new File(securityConfig.getKeytab()).getAbsolutePath();
                UserGroupInformation.loginUserFromKeytab((String)securityConfig.getPrincipal(), (String)keytabPath);
                this.loginUser = UserGroupInformation.getLoginUser();
                String fileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
                if (fileLocation != null) {
                    try {
                        Method readTokenStorageFileMethod = Credentials.class.getMethod("readTokenStorageFile", File.class, Configuration.class);
                        Credentials cred = (Credentials)readTokenStorageFileMethod.invoke(null, new File(fileLocation), securityConfig.getHadoopConfiguration());
                        Method addCredentialsMethod = UserGroupInformation.class.getMethod("addCredentials", Credentials.class);
                        addCredentialsMethod.invoke((Object)this.loginUser, cred);
                    }
                    catch (NoSuchMethodException e) {
                        LOG.warn("Could not find method implementations in the shaded jar. Exception: {}", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
            } else {
                try {
                    Method loginUserFromSubjectMethod = UserGroupInformation.class.getMethod("loginUserFromSubject", Subject.class);
                    loginUserFromSubjectMethod.invoke(null, new Object[]{null});
                }
                catch (NoSuchMethodException e) {
                    LOG.warn("Could not find method implementations in the shaded jar. Exception: {}", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                this.loginUser = UserGroupInformation.getLoginUser();
            }
            if (UserGroupInformation.isSecurityEnabled() && securityConfig.useTicketCache() && !this.loginUser.hasKerberosCredentials() && !HadoopUtils.hasHDFSDelegationToken()) {
                LOG.warn("Hadoop security is enabled but current login user does not have Kerberos credentials");
            }
            LOG.info("Hadoop user set to {}", (Object)this.loginUser);
        }
        catch (Throwable ex) {
            throw new SecurityModule.SecurityInstallException("Unable to set the Hadoop login user", ex);
        }
    }

    @Override
    public void uninstall() throws SecurityModule.SecurityInstallException {
        throw new UnsupportedOperationException();
    }
}

