/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationProxy;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public class KeyedBackendSerializationProxy
extends VersionedIOReadableWritable {
    private static final int VERSION = 1;
    private TypeSerializerSerializationProxy<?> keySerializerProxy;
    private List<StateMetaInfo<?, ?>> namedStateSerializationProxies;
    private ClassLoader userCodeClassLoader;

    public KeyedBackendSerializationProxy(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
    }

    public KeyedBackendSerializationProxy(TypeSerializer<?> keySerializer, List<StateMetaInfo<?, ?>> namedStateSerializationProxies) {
        this.keySerializerProxy = new TypeSerializerSerializationProxy((TypeSerializer)Preconditions.checkNotNull(keySerializer));
        this.namedStateSerializationProxies = (List)Preconditions.checkNotNull(namedStateSerializationProxies);
        Preconditions.checkArgument((namedStateSerializationProxies.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
    }

    public List<StateMetaInfo<?, ?>> getNamedStateSerializationProxies() {
        return this.namedStateSerializationProxies;
    }

    public TypeSerializerSerializationProxy<?> getKeySerializerProxy() {
        return this.keySerializerProxy;
    }

    public int getVersion() {
        return 1;
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.keySerializerProxy.write(out);
        out.writeShort(this.namedStateSerializationProxies.size());
        for (StateMetaInfo<?, ?> kvState : this.namedStateSerializationProxies) {
            kvState.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.keySerializerProxy = new TypeSerializerSerializationProxy(this.userCodeClassLoader);
        this.keySerializerProxy.read(in);
        int numKvStates = in.readShort();
        this.namedStateSerializationProxies = new ArrayList(numKvStates);
        for (int i = 0; i < numKvStates; ++i) {
            StateMetaInfo stateSerializationProxy = new StateMetaInfo(this.userCodeClassLoader);
            stateSerializationProxy.read(in);
            this.namedStateSerializationProxies.add(stateSerializationProxy);
        }
    }

    public static class StateMetaInfo<N, S>
    implements IOReadableWritable {
        private StateDescriptor.Type stateType;
        private String stateName;
        private TypeSerializerSerializationProxy<N> namespaceSerializerSerializationProxy;
        private TypeSerializerSerializationProxy<S> stateSerializerSerializationProxy;
        private ClassLoader userClassLoader;

        StateMetaInfo(ClassLoader userClassLoader) {
            this.userClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userClassLoader);
        }

        public StateMetaInfo(StateDescriptor.Type stateType, String name, TypeSerializer<N> namespaceSerializer, TypeSerializer<S> stateSerializer) {
            this.stateType = (StateDescriptor.Type)Preconditions.checkNotNull((Object)stateType);
            this.stateName = (String)Preconditions.checkNotNull((Object)name);
            this.namespaceSerializerSerializationProxy = new TypeSerializerSerializationProxy((TypeSerializer)Preconditions.checkNotNull(namespaceSerializer));
            this.stateSerializerSerializationProxy = new TypeSerializerSerializationProxy((TypeSerializer)Preconditions.checkNotNull(stateSerializer));
        }

        public StateDescriptor.Type getStateType() {
            return this.stateType;
        }

        public void setStateType(StateDescriptor.Type stateType) {
            this.stateType = stateType;
        }

        public String getStateName() {
            return this.stateName;
        }

        public void setStateName(String stateName) {
            this.stateName = stateName;
        }

        public TypeSerializerSerializationProxy<N> getNamespaceSerializerSerializationProxy() {
            return this.namespaceSerializerSerializationProxy;
        }

        public void setNamespaceSerializerSerializationProxy(TypeSerializerSerializationProxy<N> namespaceSerializerSerializationProxy) {
            this.namespaceSerializerSerializationProxy = namespaceSerializerSerializationProxy;
        }

        public TypeSerializerSerializationProxy<S> getStateSerializerSerializationProxy() {
            return this.stateSerializerSerializationProxy;
        }

        public void setStateSerializerSerializationProxy(TypeSerializerSerializationProxy<S> stateSerializerSerializationProxy) {
            this.stateSerializerSerializationProxy = stateSerializerSerializationProxy;
        }

        public void write(DataOutputView out) throws IOException {
            out.writeInt(this.getStateType().ordinal());
            out.writeUTF(this.getStateName());
            this.getNamespaceSerializerSerializationProxy().write(out);
            this.getStateSerializerSerializationProxy().write(out);
        }

        public void read(DataInputView in) throws IOException {
            int enumOrdinal = in.readInt();
            this.setStateType(StateDescriptor.Type.values()[enumOrdinal]);
            this.setStateName(in.readUTF());
            this.namespaceSerializerSerializationProxy = new TypeSerializerSerializationProxy(this.userClassLoader);
            this.namespaceSerializerSerializationProxy.read(in);
            this.stateSerializerSerializationProxy = new TypeSerializerSerializationProxy(this.userClassLoader);
            this.stateSerializerSerializationProxy.read(in);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateMetaInfo that = (StateMetaInfo)o;
            if (!this.getStateName().equals(that.getStateName())) {
                return false;
            }
            if (!this.getNamespaceSerializerSerializationProxy().equals(that.getNamespaceSerializerSerializationProxy())) {
                return false;
            }
            return this.getStateSerializerSerializationProxy().equals(that.getStateSerializerSerializationProxy());
        }

        public int hashCode() {
            int result = this.getStateName().hashCode();
            result = 31 * result + this.getNamespaceSerializerSerializationProxy().hashCode();
            result = 31 * result + this.getStateSerializerSerializationProxy().hashCode();
            return result;
        }
    }
}

