/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap.async;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.query.netty.message.KvStateRequestSerializer;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.heap.async.StateTable;
import org.apache.flink.util.Preconditions;

public abstract class AbstractHeapState<K, N, SV, S extends State, SD extends StateDescriptor<S, ?>>
implements KvState<N>,
State {
    protected final StateTable<K, N, SV> stateTable;
    protected final SD stateDesc;
    protected N currentNamespace;
    protected final TypeSerializer<K> keySerializer;
    protected final TypeSerializer<N> namespaceSerializer;

    protected AbstractHeapState(SD stateDesc, StateTable<K, N, SV> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        this.stateDesc = stateDesc;
        this.stateTable = (StateTable)Preconditions.checkNotNull(stateTable, (String)"State table must not be null.");
        this.keySerializer = keySerializer;
        this.namespaceSerializer = namespaceSerializer;
        this.currentNamespace = null;
    }

    public final void clear() {
        this.stateTable.remove(this.currentNamespace);
    }

    @Override
    public final void setCurrentNamespace(N namespace) {
        this.currentNamespace = Preconditions.checkNotNull(namespace, (String)"Namespace must not be null.");
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace) throws Exception {
        Preconditions.checkNotNull((Object)serializedKeyAndNamespace, (String)"Serialized key and namespace");
        Tuple2<K, N> keyAndNamespace = KvStateRequestSerializer.deserializeKeyAndNamespace(serializedKeyAndNamespace, this.keySerializer, this.namespaceSerializer);
        return this.getSerializedValue(keyAndNamespace.f0, keyAndNamespace.f1);
    }

    public byte[] getSerializedValue(K key, N namespace) throws Exception {
        Preconditions.checkState((namespace != null ? 1 : 0) != 0, (Object)"No namespace given.");
        Preconditions.checkState((key != null ? 1 : 0) != 0, (Object)"No key given.");
        SV result = this.stateTable.get(key, namespace);
        if (result == null) {
            return null;
        }
        TypeSerializer serializer = this.stateDesc.getSerializer();
        return KvStateRequestSerializer.serializeValue(result, serializer);
    }

    @VisibleForTesting
    public StateTable<K, N, SV> getStateTable() {
        return this.stateTable;
    }
}

