/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap.async;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.heap.async.AbstractHeapState;
import org.apache.flink.runtime.state.heap.async.StateTable;

public class HeapValueState<K, N, V>
extends AbstractHeapState<K, N, V, ValueState<V>, ValueStateDescriptor<V>>
implements ValueState<V> {
    public HeapValueState(ValueStateDescriptor<V> stateDesc, StateTable<K, N, V> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        super(stateDesc, stateTable, keySerializer, namespaceSerializer);
    }

    public V value() {
        Object result = this.stateTable.get(this.currentNamespace);
        if (result == null) {
            return (V)((ValueStateDescriptor)this.stateDesc).getDefaultValue();
        }
        return (V)result;
    }

    public void update(V value) {
        if (value == null) {
            this.clear();
            return;
        }
        this.stateTable.put(this.currentNamespace, value);
    }
}

