/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class JvmShutdownSafeguard
extends Thread {
    private static final long DEFAULT_DELAY = 5000L;
    private static final int EXIT_CODE = -17;
    private final Thread terminator;

    private JvmShutdownSafeguard(long delayMillis) {
        this.setName("JVM Terminator Launcher");
        this.terminator = new Thread((Runnable)new DelayedTerminator(delayMillis), "Jvm Terminator");
        this.terminator.setDaemon(true);
    }

    @Override
    public void run() {
        this.terminator.start();
    }

    public static void installAsShutdownHook(Logger logger) {
        JvmShutdownSafeguard.installAsShutdownHook(logger, 5000L);
    }

    public static void installAsShutdownHook(Logger logger, long delayMillis) {
        Preconditions.checkArgument((delayMillis >= 0L ? 1 : 0) != 0, (Object)"delay must be >= 0");
        JvmShutdownSafeguard shutdownHook = new JvmShutdownSafeguard(delayMillis);
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable t) {
            logger.error("Cannot install JVM Shutdown Safeguard against blocked shutdown hooks");
        }
    }

    private static class DelayedTerminator
    implements Runnable {
        private final long delayMillis;

        private DelayedTerminator(long delayMillis) {
            this.delayMillis = delayMillis;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delayMillis);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Runtime.getRuntime().halt(-17);
        }
    }
}

