/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import akka.actor.ActorSystem;
import java.util.concurrent.TimeoutException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.concurrent.duration.Duration;

public class ProcessShutDownThread
extends Thread {
    private final Logger log;
    private final ActorSystem actorSystem;
    private final Duration terminationTimeout;

    public ProcessShutDownThread(Logger log, ActorSystem actorSystem, Duration terminationTimeout) {
        this.log = (Logger)Preconditions.checkNotNull((Object)log, (String)"Logger");
        this.actorSystem = (ActorSystem)Preconditions.checkNotNull((Object)actorSystem, (String)"Actor system");
        this.terminationTimeout = (Duration)Preconditions.checkNotNull((Object)terminationTimeout, (String)"Termination timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.actorSystem.awaitTermination(this.terminationTimeout);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                this.log.error("Actor system shut down timed out.", (Throwable)e);
            } else {
                this.log.error("Failure during actor system shut down.", (Throwable)e);
            }
        }
        finally {
            this.log.info("Shutdown completed. Stopping JVM.");
            System.exit(0);
        }
    }
}

