/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobCache;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.TestingFailingBlobServer;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobCacheRetriesTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testBlobFetchRetries() throws IOException {
        Configuration config = new Configuration();
        this.testBlobFetchRetries(config, (BlobStore)new VoidBlobStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlobFetchRetriesHa() throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.getRoot().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            this.testBlobFetchRetries(config, (BlobStore)blobStoreService);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBlobFetchRetries(Configuration config, BlobStore blobStore) throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        TestingFailingBlobServer server = null;
        BlobCache cache = null;
        try {
            BlobKey key;
            server = new TestingFailingBlobServer(config, blobStore, 2);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            try (BlobClient blobClient = null;){
                blobClient = new BlobClient(serverAddress, config);
                key = blobClient.put(data);
            }
            cache = new BlobCache(serverAddress, config, (BlobView)new VoidBlobStore());
            URL url = cache.getURL(key);
            try (InputStream is = url.openStream();){
                byte[] received = new byte[data.length];
                Assert.assertEquals((long)data.length, (long)is.read(received));
                Assert.assertArrayEquals((byte[])data, (byte[])received);
            }
        }
        finally {
            if (cache != null) {
                cache.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    @Test
    public void testBlobFetchWithTooManyFailures() throws IOException {
        Configuration config = new Configuration();
        this.testBlobFetchWithTooManyFailures(config, (BlobStore)new VoidBlobStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlobFetchWithTooManyFailuresHa() throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.getRoot().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            this.testBlobFetchWithTooManyFailures(config, (BlobStore)blobStoreService);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBlobFetchWithTooManyFailures(Configuration config, BlobStore blobStore) throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        TestingFailingBlobServer server = null;
        BlobCache cache = null;
        try {
            BlobKey key;
            server = new TestingFailingBlobServer(config, blobStore, 10);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            try (BlobClient blobClient = null;){
                blobClient = new BlobClient(serverAddress, config);
                key = blobClient.put(data);
            }
            cache = new BlobCache(serverAddress, config, (BlobView)new VoidBlobStore());
            try {
                cache.getURL(key);
                Assert.fail((String)"This should fail");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (cache != null) {
                cache.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }
}

