/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobCache;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobCacheSuccessTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testBlobCache() throws IOException {
        Configuration config = new Configuration();
        this.uploadFileGetTest(config, false, false);
    }

    @Test
    public void testBlobCacheHa() throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.getRoot().getPath());
        this.uploadFileGetTest(config, true, true);
    }

    @Test
    public void testBlobCacheHaFallback() throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.getRoot().getPath());
        this.uploadFileGetTest(config, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFileGetTest(Configuration config, boolean cacheWorksWithoutServer, boolean cacheHasAccessToFs) throws IOException {
        byte[] buf = new byte[128];
        ArrayList<BlobKey> blobKeys = new ArrayList<BlobKey>(2);
        BlobServer blobServer = null;
        BlobCache blobCache = null;
        BlobStoreService blobStoreService = null;
        try {
            Configuration cacheConfig;
            if (cacheHasAccessToFs) {
                cacheConfig = config;
            } else {
                cacheConfig = new Configuration(config);
                cacheConfig.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.getRoot().getPath() + "/does-not-exist");
            }
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)cacheConfig);
            blobServer = new BlobServer(config, (BlobStore)blobStoreService);
            InetSocketAddress serverAddress = new InetSocketAddress(blobServer.getPort());
            try (BlobClient blobClient = null;){
                blobClient = new BlobClient(serverAddress, config);
                blobKeys.add(blobClient.put(buf));
                buf[0] = 1;
                blobKeys.add(blobClient.put(buf));
            }
            if (cacheWorksWithoutServer) {
                blobServer.close();
                blobServer = null;
            }
            blobCache = new BlobCache(serverAddress, cacheConfig, (BlobView)blobStoreService);
            for (BlobKey blobKey : blobKeys) {
                blobCache.getURL(blobKey);
            }
            if (blobServer != null) {
                blobServer.close();
                blobServer = null;
            }
            URL[] urls = new URL[blobKeys.size()];
            for (int i = 0; i < blobKeys.size(); ++i) {
                urls[i] = blobCache.getURL((BlobKey)blobKeys.get(i));
            }
            Assert.assertEquals((long)blobKeys.size(), (long)urls.length);
            for (URL url : urls) {
                Assert.assertNotNull((Object)url);
                try {
                    File cachedFile = new File(url.toURI());
                    Assert.assertTrue((boolean)cachedFile.exists());
                    Assert.assertEquals((long)buf.length, (long)cachedFile.length());
                }
                catch (URISyntaxException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
        finally {
            if (blobServer != null) {
                blobServer.close();
            }
            if (blobCache != null) {
                blobCache.close();
            }
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }
}

