/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BlobClientSslTest
extends TestLogger {
    private static final int TEST_BUFFER_SIZE = 17000;
    private static BlobServer BLOB_SSL_SERVER;
    private static Configuration sslClientConfig;
    private static BlobServer BLOB_SERVER;
    private static Configuration clientConfig;

    @BeforeClass
    public static void startSSLServer() throws IOException {
        Configuration config = new Configuration();
        config.setBoolean("security.ssl.enabled", true);
        config.setString("security.ssl.keystore", "src/test/resources/local127.keystore");
        config.setString("security.ssl.keystore-password", "password");
        config.setString("security.ssl.key-password", "password");
        BLOB_SSL_SERVER = new BlobServer(config, (BlobStore)new VoidBlobStore());
        sslClientConfig = new Configuration();
        sslClientConfig.setBoolean("security.ssl.enabled", true);
        sslClientConfig.setString("security.ssl.truststore", "src/test/resources/local127.truststore");
        sslClientConfig.setString("security.ssl.truststore-password", "password");
    }

    @BeforeClass
    public static void startNonSSLServer() throws IOException {
        Configuration config = new Configuration();
        config.setBoolean("security.ssl.enabled", true);
        config.setBoolean("blob.service.ssl.enabled", false);
        config.setString("security.ssl.keystore", "src/test/resources/local127.keystore");
        config.setString("security.ssl.keystore-password", "password");
        config.setString("security.ssl.key-password", "password");
        BLOB_SERVER = new BlobServer(config, (BlobStore)new VoidBlobStore());
        clientConfig = new Configuration();
        clientConfig.setBoolean("security.ssl.enabled", true);
        clientConfig.setBoolean("blob.service.ssl.enabled", false);
        clientConfig.setString("security.ssl.truststore", "src/test/resources/local127.truststore");
        clientConfig.setString("security.ssl.truststore-password", "password");
    }

    @AfterClass
    public static void stopServers() throws IOException {
        if (BLOB_SSL_SERVER != null) {
            BLOB_SSL_SERVER.close();
        }
        if (BLOB_SERVER != null) {
            BLOB_SERVER.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlobKey prepareTestFile(File file) throws IOException {
        MessageDigest md = BlobUtils.createMessageDigest();
        byte[] buf = new byte[17000];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(i % 128);
        }
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            for (int i = 0; i < 20; ++i) {
                fos.write(buf);
                md.update(buf);
            }
        }
        return new BlobKey(md.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateGet(InputStream inputStream, File file) throws IOException {
        try (FileInputStream inputStream2 = null;){
            int r1;
            inputStream2 = new FileInputStream(file);
            do {
                r1 = inputStream.read();
                int r2 = ((InputStream)inputStream2).read();
                Assert.assertEquals((long)r2, (long)r1);
            } while (r1 >= 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentAddressableStream() {
        BlobClient client = null;
        InputStream is = null;
        try {
            File testFile = File.createTempFile("testfile", ".dat");
            testFile.deleteOnExit();
            BlobKey origKey = BlobClientSslTest.prepareTestFile(testFile);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", BLOB_SSL_SERVER.getPort());
            client = new BlobClient(serverAddress, sslClientConfig);
            is = new FileInputStream(testFile);
            BlobKey receivedKey = client.put(is);
            Assert.assertEquals((Object)origKey, (Object)receivedKey);
            is.close();
            is = null;
            is = client.get(receivedKey);
            BlobClientSslTest.validateGet(is, testFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegularStream() {
        JobID jobID = JobID.generate();
        String key = "testkey3";
        try {
            File testFile = File.createTempFile("testfile", ".dat");
            testFile.deleteOnExit();
            BlobClientSslTest.prepareTestFile(testFile);
            BlobClient client = null;
            InputStream is = null;
            try {
                InetSocketAddress serverAddress = new InetSocketAddress("localhost", BLOB_SSL_SERVER.getPort());
                client = new BlobClient(serverAddress, sslClientConfig);
                is = new FileInputStream(testFile);
                client.put(jobID, "testkey3", is);
                is.close();
                is = null;
                is = client.get(jobID, "testkey3");
                BlobClientSslTest.validateGet(is, testFile);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void uploadJarFile(BlobServer blobServer, Configuration blobClientConfig) throws Exception {
        File testFile = File.createTempFile("testfile", ".dat");
        testFile.deleteOnExit();
        BlobClientSslTest.prepareTestFile(testFile);
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", blobServer.getPort());
        List blobKeys = BlobClient.uploadJarFiles((InetSocketAddress)serverAddress, (Configuration)blobClientConfig, Collections.singletonList(new Path(testFile.toURI())));
        Assert.assertEquals((long)1L, (long)blobKeys.size());
        try (BlobClient blobClient = new BlobClient(serverAddress, blobClientConfig);){
            InputStream is = blobClient.get((BlobKey)blobKeys.get(0));
            BlobClientSslTest.validateGet(is, testFile);
        }
    }

    @Test
    public void testUploadJarFilesHelper() throws Exception {
        this.uploadJarFile(BLOB_SSL_SERVER, sslClientConfig);
    }

    @Test
    public void testSSLClientFailure() throws Exception {
        try {
            this.uploadJarFile(BLOB_SERVER, sslClientConfig);
            Assert.fail((String)"SSL client connected to non-ssl server");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSSLServerFailure() throws Exception {
        try {
            this.uploadJarFile(BLOB_SSL_SERVER, clientConfig);
            Assert.fail((String)"Non-SSL client connected to ssl server");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNonSSLConnection() throws Exception {
        this.uploadJarFile(BLOB_SERVER, clientConfig);
    }
}

