/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;

public class BlobServerDeleteTest
extends TestLogger {
    private final Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteSingle() {
        BlobServer server = null;
        BlobClient client = null;
        VoidBlobStore blobStore = new VoidBlobStore();
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)blobStore);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress, config);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            client.delete(key);
            client.close();
            client = new BlobClient(serverAddress, config);
            try {
                client.get(key);
                Assert.fail((String)"BLOB should have been deleted");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                client.put(new byte[1]);
                Assert.fail((String)"client should be closed after erroneous operation");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.cleanup(server, client);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                this.cleanup(server, client);
            }
            catch (Throwable throwable) {
                this.cleanup(server, client);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAll() {
        BlobServer server = null;
        BlobClient client = null;
        VoidBlobStore blobStore = new VoidBlobStore();
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)blobStore);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress, config);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            JobID jobID = new JobID();
            String name1 = "random name";
            String name2 = "any nyme";
            client.put(jobID, name1, data);
            client.put(jobID, name2, new byte[712]);
            client.deleteAll(jobID);
            client.close();
            client = new BlobClient(serverAddress, config);
            try {
                client.get(jobID, name1);
                Assert.fail((String)"BLOB should have been deleted");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                client.put(new byte[1]);
                Assert.fail((String)"client should be closed after erroneous operation");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            client = new BlobClient(serverAddress, config);
            try {
                client.get(jobID, name2);
                Assert.fail((String)"BLOB should have been deleted");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cleanup(server, client);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                this.cleanup(server, client);
            }
            catch (Throwable throwable) {
                this.cleanup(server, client);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAlreadyDeletedByBlobKey() {
        BlobServer server = null;
        BlobClient client = null;
        VoidBlobStore blobStore = new VoidBlobStore();
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)blobStore);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress, config);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(key);
            Assert.assertTrue((boolean)blobFile.delete());
            try {
                client.delete(key);
            }
            catch (IOException e) {
                Assert.fail((String)"DELETE operation should not fail if file is already deleted");
            }
            this.cleanup(server, client);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                this.cleanup(server, client);
            }
            catch (Throwable throwable) {
                this.cleanup(server, client);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAlreadyDeletedByName() {
        BlobServer server = null;
        BlobClient client = null;
        VoidBlobStore blobStore = new VoidBlobStore();
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)blobStore);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress, config);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            JobID jid = new JobID();
            String name = "------------fdghljEgRJHF+##4U789Q345";
            client.put(jid, name, data);
            File blobFile = server.getStorageLocation(jid, name);
            Assert.assertTrue((boolean)blobFile.delete());
            try {
                client.delete(jid, name);
            }
            catch (IOException e) {
                Assert.fail((String)"DELETE operation should not fail if file is already deleted");
            }
            this.cleanup(server, client);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                this.cleanup(server, client);
            }
            catch (Throwable throwable) {
                this.cleanup(server, client);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFails() {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        BlobServer server = null;
        BlobClient client = null;
        VoidBlobStore blobStore = new VoidBlobStore();
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)blobStore);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress, config);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(key);
            File directory = blobFile.getParentFile();
            Assert.assertTrue((boolean)blobFile.setWritable(false, false));
            Assert.assertTrue((boolean)directory.setWritable(false, false));
            try {
                client.delete(key);
                Assert.fail((String)"DELETE operation should fail if file cannot be deleted");
            }
            catch (IOException iOException) {
            }
            finally {
                blobFile.setWritable(true, false);
                directory.setWritable(true, false);
            }
            this.cleanup(server, client);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
                this.cleanup(server, client);
            }
            catch (Throwable throwable) {
                this.cleanup(server, client);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentDeleteOperations() throws IOException, ExecutionException, InterruptedException {
        Configuration configuration = new Configuration();
        BlobStore blobStore = (BlobStore)Mockito.mock(BlobStore.class);
        int concurrentDeleteOperations = 3;
        ExecutorService executor = Executors.newFixedThreadPool(3);
        ArrayList<Future> deleteFutures = new ArrayList<Future>(3);
        byte[] data = new byte[]{1, 2, 3};
        try (final BlobServer blobServer = new BlobServer(configuration, blobStore);){
            BlobKey blobKey;
            try (BlobClient client = blobServer.createClient();){
                blobKey = client.put(data);
            }
            Assert.assertTrue((boolean)blobServer.getStorageLocation(blobKey).exists());
            for (int i = 0; i < 3; ++i) {
                Future deleteFuture = FlinkCompletableFuture.supplyAsync((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try (BlobClient blobClient = blobServer.createClient();){
                            blobClient.delete(blobKey);
                        }
                        return null;
                    }
                }, (Executor)executor);
                deleteFutures.add(deleteFuture);
            }
            FutureUtils.ConjunctFuture waitFuture = FutureUtils.waitForAll(deleteFutures);
            waitFuture.get();
            Assert.assertFalse((boolean)blobServer.getStorageLocation(blobKey).exists());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void cleanup(BlobServer server, BlobClient client) {
        if (client != null) {
            try {
                client.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (server != null) {
            try {
                server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

