/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerConnection;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class BlobServerGetTest
extends TestLogger {
    private final Random rnd = new Random();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFailsDuringLookup() throws IOException {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)new VoidBlobStore());
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress, config);
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(key);
            Assert.assertTrue((boolean)blobFile.delete());
            try {
                client.get(key);
                Assert.fail((String)"This should not succeed.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFailsDuringStreaming() throws IOException {
        BlobServer server = null;
        BlobClient client = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)new VoidBlobStore());
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            client = new BlobClient(serverAddress, config);
            byte[] data = new byte[5000000];
            this.rnd.nextBytes(data);
            BlobKey key = client.put(data);
            Assert.assertNotNull((Object)key);
            InputStream is = client.get(key);
            byte[] receiveBuffer = new byte[50000];
            BlobUtils.readFully((InputStream)is, (byte[])receiveBuffer, (int)0, (int)receiveBuffer.length, null);
            BlobUtils.readFully((InputStream)is, (byte[])receiveBuffer, (int)0, (int)receiveBuffer.length, null);
            for (BlobServerConnection conn : server.getCurrentActiveConnections()) {
                conn.close();
            }
            try {
                byte[] remainder = new byte[data.length - 2 * receiveBuffer.length];
                BlobUtils.readFully((InputStream)is, (byte[])remainder, (int)0, (int)remainder.length, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentGetOperations() throws IOException, ExecutionException, InterruptedException {
        Configuration configuration = new Configuration();
        configuration.setString("blob.storage.directory", this.temporaryFolder.newFolder().getAbsolutePath());
        BlobStore blobStore = (BlobStore)Mockito.mock(BlobStore.class);
        int numberConcurrentGetOperations = 3;
        ArrayList<Future> getOperations = new ArrayList<Future>(3);
        final byte[] data = new byte[]{1, 2, 3, 4, 99, 42};
        final ByteArrayInputStream bais = new ByteArrayInputStream(data);
        MessageDigest md = BlobUtils.createMessageDigest();
        final BlobKey blobKey = new BlobKey(md.digest(data));
        ((BlobStore)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                File targetFile = (File)invocation.getArguments()[1];
                FileUtils.copyInputStreamToFile((InputStream)bais, (File)targetFile);
                return null;
            }
        }).when((Object)blobStore)).get((BlobKey)Matchers.any(BlobKey.class), (File)Matchers.any(File.class));
        ExecutorService executor = Executors.newFixedThreadPool(3);
        try (final BlobServer blobServer = new BlobServer(configuration, blobStore);){
            for (int i = 0; i < 3; ++i) {
                Future getOperation = FlinkCompletableFuture.supplyAsync((Callable)new Callable<InputStream>(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public InputStream call() throws Exception {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }, (Executor)executor);
                getOperations.add(getOperation);
            }
            FutureUtils.ConjunctFuture inputStreamsFuture = FutureUtils.combineAll(getOperations);
            Collection inputStreams = (Collection)inputStreamsFuture.get();
            for (InputStream inputStream : inputStreams) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
                IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
                baos.close();
                byte[] input = baos.toByteArray();
                Assert.assertArrayEquals((byte[])data, (byte[])input);
                inputStream.close();
            }
            ((BlobStore)Mockito.verify((Object)blobStore, (VerificationMode)Mockito.times((int)1))).get((BlobKey)Matchers.eq((Object)blobKey), (File)Matchers.any(File.class));
        }
        finally {
            executor.shutdownNow();
        }
    }
}

