/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class BlobServerRangeTest
extends TestLogger {
    @Test
    public void testOnEphemeralPort() throws IOException {
        Configuration conf = new Configuration();
        conf.setString("blob.server.port", "0");
        BlobServer srv = new BlobServer(conf, (BlobStore)new VoidBlobStore());
        srv.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testPortUnavailable() throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An exception was thrown while preparing the test " + e.getMessage()));
        }
        Configuration conf = new Configuration();
        conf.setString("blob.server.port", String.valueOf(socket.getLocalPort()));
        try {
            BlobServer blobServer = new BlobServer(conf, (BlobStore)new VoidBlobStore());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnePortAvailable() throws IOException {
        int numAllocated = 2;
        ServerSocket[] sockets = new ServerSocket[numAllocated];
        for (int i = 0; i < numAllocated; ++i) {
            Object socket = null;
            try {
                sockets[i] = new ServerSocket(0);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)("An exception was thrown while preparing the test " + e.getMessage()));
            }
        }
        int availablePort = NetUtils.getAvailablePort();
        Configuration conf = new Configuration();
        conf.setString("blob.server.port", sockets[0].getLocalPort() + "," + sockets[1].getLocalPort() + "," + availablePort);
        try {
            BlobServer srv = new BlobServer(conf, (BlobStore)new VoidBlobStore());
            Assert.assertEquals((long)availablePort, (long)srv.getPort());
            srv.close();
        }
        finally {
            sockets[0].close();
            sockets[1].close();
        }
    }
}

