/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.shaded.com.google.common.io.Files;
import org.apache.flink.util.OperatingSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BlobUtilsTest {
    private static final String CANNOT_CREATE_THIS = "cannot-create-this";
    private File blobUtilsTestDirectory;

    @Before
    public void before() {
        this.blobUtilsTestDirectory = Files.createTempDir();
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.blobUtilsTestDirectory.setExecutable(true, false));
        Assert.assertTrue((boolean)this.blobUtilsTestDirectory.setReadable(true, false));
        Assert.assertTrue((boolean)this.blobUtilsTestDirectory.setWritable(false, false));
    }

    @After
    public void after() {
        Assert.assertTrue((boolean)this.blobUtilsTestDirectory.delete());
    }

    @Test(expected=IOException.class)
    public void testExceptionOnCreateStorageDirectoryFailure() throws IOException {
        BlobUtils.initStorageDirectory((String)new File(this.blobUtilsTestDirectory, CANNOT_CREATE_THIS).getAbsolutePath());
    }

    @Test(expected=Exception.class)
    public void testExceptionOnCreateCacheDirectoryFailure() {
        BlobUtils.getStorageLocation((File)new File(this.blobUtilsTestDirectory, CANNOT_CREATE_THIS), (BlobKey)((BlobKey)Mockito.mock(BlobKey.class)));
    }
}

