/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerConnection;
import org.apache.flink.runtime.blob.BlobStore;

public class TestingFailingBlobServer
extends BlobServer {
    private int numFailures;

    public TestingFailingBlobServer(Configuration config, BlobStore blobStore, int numFailures) throws IOException {
        super(config, blobStore);
        this.numFailures = numFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            new BlobServerConnection(this.getServerSocket().accept(), (BlobServer)this).start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        for (int num = 0; num < this.numFailures && !this.isShutdown(); ++num) {
            Socket socket = null;
            try {
                socket = this.getServerSocket().accept();
                InputStream is = socket.getInputStream();
                OutputStream os = socket.getOutputStream();
                is.close();
                os.close();
                socket.close();
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        super.run();
    }
}

