/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointOptionsTest {
    @Test
    public void testFullCheckpoint() throws Exception {
        CheckpointOptions options = CheckpointOptions.forFullCheckpoint();
        Assert.assertEquals((Object)CheckpointOptions.CheckpointType.FULL_CHECKPOINT, (Object)options.getCheckpointType());
        Assert.assertNull((Object)options.getTargetLocation());
    }

    @Test
    public void testSavepoint() throws Exception {
        String location = "asdasdadasdasdja7931481398123123123kjhasdkajsd";
        CheckpointOptions options = CheckpointOptions.forSavepoint((String)location);
        Assert.assertEquals((Object)CheckpointOptions.CheckpointType.SAVEPOINT, (Object)options.getCheckpointType());
        Assert.assertEquals((Object)location, (Object)options.getTargetLocation());
    }

    @Test(expected=NullPointerException.class)
    public void testSavepointNullCheck() throws Exception {
        CheckpointOptions.forSavepoint(null);
    }
}

