/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class CheckpointSettingsSerializableTest
extends TestLogger {
    @Test
    public void testClassLoaderForCheckpointHooks() throws Exception {
        URLClassLoader classLoader = new URLClassLoader(new URL[0], ((Object)((Object)this)).getClass().getClassLoader());
        Serializable outOfClassPath = CommonTestUtils.createObjectForClassNotInClassPath((ClassLoader)classLoader);
        MasterTriggerRestoreHook.Factory[] hooks = new MasterTriggerRestoreHook.Factory[]{new TestFactory(outOfClassPath)};
        SerializedValue serHooks = new SerializedValue((Object)hooks);
        JobCheckpointingSettings checkpointingSettings = new JobCheckpointingSettings(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 1000L, 10000L, 0L, 1, ExternalizedCheckpointSettings.none(), null, serHooks, true);
        JobGraph jobGraph = new JobGraph(new JobID(), "test job");
        jobGraph.setSnapshotSettings(checkpointingSettings);
        JobGraph copy = (JobGraph)CommonTestUtils.createCopySerializable((Serializable)jobGraph);
        ExecutionGraph eg = ExecutionGraphBuilder.buildGraph(null, (JobGraph)copy, (Configuration)new Configuration(), (ScheduledExecutorService)TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), (SlotProvider)((SlotProvider)Mockito.mock(SlotProvider.class)), (ClassLoader)classLoader, (CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory(), (Time)Time.seconds((long)10L), (RestartStrategy)new NoRestartStrategy(), (MetricGroup)new UnregisteredMetricsGroup(), (int)10, (Logger)this.log);
        Assert.assertEquals((long)1L, (long)eg.getCheckpointCoordinator().getNumberOfRegisteredMasterHooks());
    }

    private static final class TestFactory
    implements MasterTriggerRestoreHook.Factory {
        private static final long serialVersionUID = -612969579110202607L;
        private final Serializable payload;

        TestFactory(Serializable payload) {
            this.payload = payload;
        }

        public <V> MasterTriggerRestoreHook<V> create() {
            MasterTriggerRestoreHook hook = (MasterTriggerRestoreHook)Mockito.mock(MasterTriggerRestoreHook.class);
            Mockito.when((Object)hook.getIdentifier()).thenReturn((Object)"id");
            return hook;
        }
    }
}

