/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CheckpointStatsTrackerTest {
    @Test
    public void testGetSnapshottingSettings() throws Exception {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)jobVertex.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)jobVertex.getParallelism()).thenReturn((Object)1);
        JobCheckpointingSettings snapshottingSettings = new JobCheckpointingSettings(Collections.singletonList(new JobVertexID()), Collections.singletonList(new JobVertexID()), Collections.singletonList(new JobVertexID()), 181238123L, 19191992L, 191929L, 123, ExternalizedCheckpointSettings.none(), null, false);
        CheckpointStatsTracker tracker = new CheckpointStatsTracker(0, Collections.singletonList(jobVertex), snapshottingSettings, (MetricGroup)new UnregisteredMetricsGroup());
        Assert.assertEquals((Object)snapshottingSettings, (Object)tracker.getSnapshottingSettings());
    }

    @Test
    public void testTrackerWithoutHistory() throws Exception {
        int numberOfSubtasks = 3;
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)jobVertex.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)jobVertex.getParallelism()).thenReturn((Object)numberOfSubtasks);
        CheckpointStatsTracker tracker = new CheckpointStatsTracker(0, Collections.singletonList(jobVertex), (JobCheckpointingSettings)Mockito.mock(JobCheckpointingSettings.class), (MetricGroup)new UnregisteredMetricsGroup());
        PendingCheckpointStats pending = tracker.reportPendingCheckpoint(0L, 1L, CheckpointProperties.forStandardCheckpoint());
        pending.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(0));
        pending.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(1));
        pending.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(2));
        pending.reportCompletedCheckpoint(null);
        CheckpointStatsSnapshot snapshot = tracker.createSnapshot();
        Assert.assertFalse((boolean)snapshot.getHistory().getCheckpoints().iterator().hasNext());
        CheckpointStatsCounts counts = snapshot.getCounts();
        Assert.assertEquals((long)1L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getTotalNumberOfCheckpoints());
        CompletedCheckpointStatsSummary summary = snapshot.getSummaryStats();
        Assert.assertEquals((long)1L, (long)summary.getStateSizeStats().getCount());
        Assert.assertEquals((long)1L, (long)summary.getEndToEndDurationStats().getCount());
        Assert.assertEquals((long)1L, (long)summary.getAlignmentBufferedStats().getCount());
        Assert.assertNotNull((Object)snapshot.getHistory().getLatestCompletedCheckpoint());
        Assert.assertEquals((long)0L, (long)snapshot.getHistory().getLatestCompletedCheckpoint().getCheckpointId());
    }

    @Test
    public void testCheckpointTracking() throws Exception {
        int numberOfSubtasks = 3;
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)jobVertex.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)jobVertex.getParallelism()).thenReturn((Object)numberOfSubtasks);
        CheckpointStatsTracker tracker = new CheckpointStatsTracker(10, Collections.singletonList(jobVertex), (JobCheckpointingSettings)Mockito.mock(JobCheckpointingSettings.class), (MetricGroup)new UnregisteredMetricsGroup());
        PendingCheckpointStats completed1 = tracker.reportPendingCheckpoint(0L, 1L, CheckpointProperties.forStandardCheckpoint());
        completed1.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(0));
        completed1.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(1));
        completed1.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(2));
        completed1.reportCompletedCheckpoint(null);
        PendingCheckpointStats failed = tracker.reportPendingCheckpoint(1L, 1L, CheckpointProperties.forStandardCheckpoint());
        failed.reportFailedCheckpoint(12L, null);
        PendingCheckpointStats savepoint = tracker.reportPendingCheckpoint(2L, 1L, CheckpointProperties.forStandardSavepoint());
        savepoint.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(0));
        savepoint.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(1));
        savepoint.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(2));
        savepoint.reportCompletedCheckpoint(null);
        PendingCheckpointStats inProgress = tracker.reportPendingCheckpoint(3L, 1L, CheckpointProperties.forStandardCheckpoint());
        RestoredCheckpointStats restored = new RestoredCheckpointStats(81L, CheckpointProperties.forStandardCheckpoint(), 123L, null);
        tracker.reportRestoredCheckpoint(restored);
        CheckpointStatsSnapshot snapshot = tracker.createSnapshot();
        CheckpointStatsCounts counts = snapshot.getCounts();
        Assert.assertEquals((long)4L, (long)counts.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)2L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfFailedCheckpoints());
        CompletedCheckpointStatsSummary summary = snapshot.getSummaryStats();
        Assert.assertEquals((long)2L, (long)summary.getStateSizeStats().getCount());
        Assert.assertEquals((long)2L, (long)summary.getEndToEndDurationStats().getCount());
        Assert.assertEquals((long)2L, (long)summary.getAlignmentBufferedStats().getCount());
        CheckpointStatsHistory history = snapshot.getHistory();
        Iterator it = history.getCheckpoints().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        AbstractCheckpointStats stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)3L, (long)stats.getCheckpointId());
        Assert.assertTrue((boolean)stats.getStatus().isInProgress());
        Assert.assertTrue((boolean)it.hasNext());
        stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)2L, (long)stats.getCheckpointId());
        Assert.assertTrue((boolean)stats.getStatus().isCompleted());
        Assert.assertTrue((boolean)it.hasNext());
        stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)1L, (long)stats.getCheckpointId());
        Assert.assertTrue((boolean)stats.getStatus().isFailed());
        Assert.assertTrue((boolean)it.hasNext());
        stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)0L, (long)stats.getCheckpointId());
        Assert.assertTrue((boolean)stats.getStatus().isCompleted());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((long)completed1.getCheckpointId(), (long)snapshot.getHistory().getLatestCompletedCheckpoint().getCheckpointId());
        Assert.assertEquals((long)savepoint.getCheckpointId(), (long)snapshot.getHistory().getLatestSavepoint().getCheckpointId());
        Assert.assertEquals((long)failed.getCheckpointId(), (long)snapshot.getHistory().getLatestFailedCheckpoint().getCheckpointId());
        Assert.assertEquals((Object)restored, (Object)snapshot.getLatestRestoredCheckpoint());
    }

    @Test
    public void testCreateSnapshot() throws Exception {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)jobVertex.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)jobVertex.getParallelism()).thenReturn((Object)1);
        CheckpointStatsTracker tracker = new CheckpointStatsTracker(10, Collections.singletonList(jobVertex), (JobCheckpointingSettings)Mockito.mock(JobCheckpointingSettings.class), (MetricGroup)new UnregisteredMetricsGroup());
        CheckpointStatsSnapshot snapshot1 = tracker.createSnapshot();
        PendingCheckpointStats pending = tracker.reportPendingCheckpoint(0L, 1L, CheckpointProperties.forStandardCheckpoint());
        pending.reportSubtaskStats(jobVertex.getJobVertexId(), this.createSubtaskStats(0));
        CheckpointStatsSnapshot snapshot2 = tracker.createSnapshot();
        Assert.assertNotEquals((Object)snapshot1, (Object)snapshot2);
        Assert.assertEquals((Object)snapshot2, (Object)tracker.createSnapshot());
        pending.reportCompletedCheckpoint(null);
        CheckpointStatsSnapshot snapshot3 = tracker.createSnapshot();
        Assert.assertNotEquals((Object)snapshot2, (Object)snapshot3);
        tracker.reportRestoredCheckpoint(new RestoredCheckpointStats(12L, CheckpointProperties.forStandardCheckpoint(), 12L, null));
        CheckpointStatsSnapshot snapshot4 = tracker.createSnapshot();
        Assert.assertNotEquals((Object)snapshot3, (Object)snapshot4);
        Assert.assertEquals((Object)snapshot4, (Object)tracker.createSnapshot());
    }

    @Test
    public void testMetricsRegistration() throws Exception {
        MetricGroup metricGroup = (MetricGroup)Mockito.mock(MetricGroup.class);
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)jobVertex.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)jobVertex.getParallelism()).thenReturn((Object)1);
        new CheckpointStatsTracker(0, Collections.singletonList(jobVertex), (JobCheckpointingSettings)Mockito.mock(JobCheckpointingSettings.class), metricGroup);
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"totalNumberOfCheckpoints"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"numberOfInProgressCheckpoints"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"numberOfCompletedCheckpoints"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"numberOfFailedCheckpoints"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"lastCheckpointRestoreTimestamp"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"lastCheckpointSize"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"lastCheckpointDuration"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"lastCheckpointAlignmentBuffered"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)1))).gauge((String)Matchers.eq((Object)"lastCheckpointExternalPath"), (Gauge)Matchers.any(Gauge.class));
        ((MetricGroup)Mockito.verify((Object)metricGroup, (VerificationMode)Mockito.times((int)9))).gauge((String)Matchers.any(String.class), (Gauge)Matchers.any(Gauge.class));
    }

    @Test
    public void testMetricsAreUpdated() throws Exception {
        final HashMap registeredGauges = new HashMap();
        MetricGroup metricGroup = new MetricGroup(){

            public Counter counter(int name) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public Counter counter(String name) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public <C extends Counter> C counter(int name, C counter) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public <C extends Counter> C counter(String name, C counter) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public <T, G extends Gauge<T>> G gauge(int name, G gauge) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
                registeredGauges.put(name, gauge);
                return gauge;
            }

            public <H extends Histogram> H histogram(String name, H histogram) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public <H extends Histogram> H histogram(int name, H histogram) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public <M extends Meter> M meter(String name, M meter) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public <M extends Meter> M meter(int name, M meter) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public MetricGroup addGroup(int name) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public MetricGroup addGroup(String name) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public String[] getScopeComponents() {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public Map<String, String> getAllVariables() {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public String getMetricIdentifier(String metricName) {
                throw new UnsupportedOperationException("Not expected in this test");
            }

            public String getMetricIdentifier(String metricName, CharacterFilter filter) {
                throw new UnsupportedOperationException("Not expected in this test");
            }
        };
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)jobVertex.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)jobVertex.getParallelism()).thenReturn((Object)1);
        CheckpointStatsTracker stats = new CheckpointStatsTracker(0, Collections.singletonList(jobVertex), (JobCheckpointingSettings)Mockito.mock(JobCheckpointingSettings.class), metricGroup);
        Assert.assertEquals((long)9L, (long)registeredGauges.size());
        Gauge numCheckpoints = (Gauge)registeredGauges.get("totalNumberOfCheckpoints");
        Gauge numInProgressCheckpoints = (Gauge)registeredGauges.get("numberOfInProgressCheckpoints");
        Gauge numCompletedCheckpoints = (Gauge)registeredGauges.get("numberOfCompletedCheckpoints");
        Gauge numFailedCheckpoints = (Gauge)registeredGauges.get("numberOfFailedCheckpoints");
        Gauge latestRestoreTimestamp = (Gauge)registeredGauges.get("lastCheckpointRestoreTimestamp");
        Gauge latestCompletedSize = (Gauge)registeredGauges.get("lastCheckpointSize");
        Gauge latestCompletedDuration = (Gauge)registeredGauges.get("lastCheckpointDuration");
        Gauge latestCompletedAlignmentBuffered = (Gauge)registeredGauges.get("lastCheckpointAlignmentBuffered");
        Gauge latestCompletedExternalPath = (Gauge)registeredGauges.get("lastCheckpointExternalPath");
        Assert.assertEquals((Object)0L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)0, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numFailedCheckpoints.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestRestoreTimestamp.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestCompletedSize.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestCompletedDuration.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestCompletedAlignmentBuffered.getValue());
        Assert.assertEquals((Object)"n/a", (Object)latestCompletedExternalPath.getValue());
        PendingCheckpointStats pending = stats.reportPendingCheckpoint(0L, 0L, CheckpointProperties.forStandardCheckpoint());
        Assert.assertEquals((Object)1L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)1, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numFailedCheckpoints.getValue());
        long ackTimestamp = 11231230L;
        long stateSize = 12381238L;
        long ignored = 0L;
        long alignmenetBuffered = 182812L;
        String externalPath = "myexternalpath";
        SubtaskStateStats subtaskStats = new SubtaskStateStats(0, ackTimestamp, stateSize, ignored, ignored, alignmenetBuffered, ignored);
        Assert.assertTrue((boolean)pending.reportSubtaskStats(jobVertex.getJobVertexId(), subtaskStats));
        pending.reportCompletedCheckpoint(externalPath);
        Assert.assertEquals((Object)1L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)0, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numFailedCheckpoints.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestRestoreTimestamp.getValue());
        Assert.assertEquals((Object)stateSize, (Object)latestCompletedSize.getValue());
        Assert.assertEquals((Object)ackTimestamp, (Object)latestCompletedDuration.getValue());
        Assert.assertEquals((Object)alignmenetBuffered, (Object)latestCompletedAlignmentBuffered.getValue());
        Assert.assertEquals((Object)externalPath, (Object)latestCompletedExternalPath.getValue());
        PendingCheckpointStats nextPending = stats.reportPendingCheckpoint(1L, 11L, CheckpointProperties.forStandardCheckpoint());
        long failureTimestamp = 1230123L;
        nextPending.reportFailedCheckpoint(failureTimestamp, null);
        Assert.assertEquals((Object)2L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)0, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numFailedCheckpoints.getValue());
        long restoreTimestamp = 183419283L;
        RestoredCheckpointStats restored = new RestoredCheckpointStats(1L, CheckpointProperties.forStandardCheckpoint(), restoreTimestamp, null);
        stats.reportRestoredCheckpoint(restored);
        Assert.assertEquals((Object)2L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)0, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numFailedCheckpoints.getValue());
        Assert.assertEquals((Object)restoreTimestamp, (Object)latestRestoreTimestamp.getValue());
    }

    static CheckpointStatsTracker createTestTracker() {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)jobVertex.getJobVertexId()).thenReturn((Object)new JobVertexID());
        Mockito.when((Object)jobVertex.getParallelism()).thenReturn((Object)1);
        return new CheckpointStatsTracker(0, Collections.singletonList(jobVertex), (JobCheckpointingSettings)Mockito.mock(JobCheckpointingSettings.class), (MetricGroup)new UnregisteredMetricsGroup());
    }

    private SubtaskStateStats createSubtaskStats(int index) {
        return new SubtaskStateStats(index, 0L, 0L, 0L, 0L, 0L, 0L);
    }
}

