/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTrackerTest;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartAllStrategy;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.instance.SlotProvider;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.SerializedValue;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExecutionGraphCheckpointCoordinatorTest {
    @Test
    public void testShutdownCheckpointCoordinator() throws Exception {
        CheckpointIDCounter counter = (CheckpointIDCounter)Mockito.mock(CheckpointIDCounter.class);
        CompletedCheckpointStore store = (CompletedCheckpointStore)Mockito.mock(CompletedCheckpointStore.class);
        ExecutionGraph graph = this.createExecutionGraphAndEnableCheckpointing(counter, store);
        graph.failGlobal((Throwable)new Exception("Test Exception"));
        ((CheckpointIDCounter)Mockito.verify((Object)counter, (VerificationMode)Mockito.times((int)1))).shutdown(JobStatus.FAILED);
        ((CompletedCheckpointStore)Mockito.verify((Object)store, (VerificationMode)Mockito.times((int)1))).shutdown((JobStatus)Matchers.eq((Object)JobStatus.FAILED));
    }

    @Test
    public void testSuspendCheckpointCoordinator() throws Exception {
        CheckpointIDCounter counter = (CheckpointIDCounter)Mockito.mock(CheckpointIDCounter.class);
        CompletedCheckpointStore store = (CompletedCheckpointStore)Mockito.mock(CompletedCheckpointStore.class);
        ExecutionGraph graph = this.createExecutionGraphAndEnableCheckpointing(counter, store);
        graph.suspend((Throwable)new Exception("Test Exception"));
        ((CheckpointIDCounter)Mockito.verify((Object)counter, (VerificationMode)Mockito.times((int)1))).shutdown((JobStatus)Matchers.eq((Object)JobStatus.SUSPENDED));
        ((CompletedCheckpointStore)Mockito.verify((Object)store, (VerificationMode)Mockito.times((int)1))).shutdown((JobStatus)Matchers.eq((Object)JobStatus.SUSPENDED));
    }

    private ExecutionGraph createExecutionGraphAndEnableCheckpointing(CheckpointIDCounter counter, CompletedCheckpointStore store) throws Exception {
        ExecutionGraph executionGraph = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), new JobID(), "test", new Configuration(), new SerializedValue((Object)new ExecutionConfig()), Time.days((long)1L), (RestartStrategy)new NoRestartStrategy(), (FailoverStrategy.Factory)new RestartAllStrategy.Factory(), Collections.emptyList(), Collections.emptyList(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()), ClassLoader.getSystemClassLoader());
        executionGraph.enableCheckpointing(100L, 100L, 100L, 1, ExternalizedCheckpointSettings.none(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), counter, store, null, null, CheckpointStatsTrackerTest.createTestTracker());
        JobVertex jobVertex = new JobVertex("MockVertex");
        jobVertex.setInvokableClass(AbstractInvokable.class);
        executionGraph.attachJobGraph(Collections.singletonList(jobVertex));
        return executionGraph;
    }
}

