/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ContaineredTaskManagerParametersTest
extends TestLogger {
    private static final long CONTAINER_MEMORY = 8192L;

    @Test
    public void testOffHeapMemoryWithDefaultConfiguration() {
        Configuration conf = new Configuration();
        ContaineredTaskManagerParameters params = ContaineredTaskManagerParameters.create((Configuration)conf, (long)8192L, (int)1);
        Assert.assertEquals((long)-1L, (long)params.taskManagerDirectMemoryLimitMB());
    }

    @Test
    public void testTotalMemoryDoesNotExceedContainerMemory() {
        Configuration conf = new Configuration();
        conf.setBoolean(TaskManagerOptions.MEMORY_OFF_HEAP, true);
        ContaineredTaskManagerParameters params = ContaineredTaskManagerParameters.create((Configuration)conf, (long)8192L, (int)1);
        Assert.assertTrue((params.taskManagerDirectMemoryLimitMB() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((params.taskManagerHeapSizeMB() + params.taskManagerDirectMemoryLimitMB() <= 8192L ? 1 : 0) != 0);
    }
}

