/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.util.HashMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlayTestBase;
import org.apache.flink.runtime.clusterframework.overlays.HadoopConfOverlay;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HadoopConfOverlayTest
extends ContainerOverlayTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testConfigure() throws Exception {
        File confDir = this.tempFolder.newFolder();
        this.initConfDir(confDir);
        HadoopConfOverlay overlay = new HadoopConfOverlay(confDir);
        ContainerSpecification spec = new ContainerSpecification();
        overlay.configure(spec);
        Assert.assertEquals((Object)HadoopConfOverlay.TARGET_CONF_DIR.getPath(), spec.getEnvironmentVariables().get("HADOOP_CONF_DIR"));
        Assert.assertEquals((Object)HadoopConfOverlay.TARGET_CONF_DIR.getPath(), (Object)spec.getDynamicConfiguration().getString("fs.hdfs.hadoopconf", null));
        HadoopConfOverlayTest.checkArtifact(spec, new Path(HadoopConfOverlay.TARGET_CONF_DIR, "core-site.xml"));
        HadoopConfOverlayTest.checkArtifact(spec, new Path(HadoopConfOverlay.TARGET_CONF_DIR, "hdfs-site.xml"));
    }

    @Test
    public void testNoConf() throws Exception {
        HadoopConfOverlay overlay = new HadoopConfOverlay(null);
        ContainerSpecification containerSpecification = new ContainerSpecification();
        overlay.configure(containerSpecification);
    }

    @Test
    public void testBuilderFromEnvironment() throws Exception {
        File confDir = this.tempFolder.newFolder();
        this.initConfDir(confDir);
        Configuration conf = new Configuration();
        conf.setString("fs.hdfs.hadoopconf", confDir.getAbsolutePath());
        HadoopConfOverlay.Builder builder = HadoopConfOverlay.newBuilder().fromEnvironment(conf);
        Assert.assertEquals((Object)confDir, (Object)builder.hadoopConfDir);
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.remove("HADOOP_HOME");
        env.put("HADOOP_CONF_DIR", confDir.getAbsolutePath());
        CommonTestUtils.setEnv(env);
        builder = HadoopConfOverlay.newBuilder().fromEnvironment(new Configuration());
        Assert.assertEquals((Object)confDir, (Object)builder.hadoopConfDir);
        File homeDir = this.tempFolder.newFolder();
        confDir = this.initConfDir(new File(homeDir, "conf"));
        env = new HashMap<String, String>(System.getenv());
        env.remove("HADOOP_CONF_DIR");
        env.put("HADOOP_HOME", homeDir.getAbsolutePath());
        CommonTestUtils.setEnv(env);
        builder = HadoopConfOverlay.newBuilder().fromEnvironment(new Configuration());
        Assert.assertEquals((Object)confDir, (Object)builder.hadoopConfDir);
        homeDir = this.tempFolder.newFolder();
        confDir = this.initConfDir(new File(homeDir, "etc/hadoop"));
        env = new HashMap<String, String>(System.getenv());
        env.remove("HADOOP_CONF_DIR");
        env.put("HADOOP_HOME", homeDir.getAbsolutePath());
        CommonTestUtils.setEnv(env);
        builder = HadoopConfOverlay.newBuilder().fromEnvironment(new Configuration());
        Assert.assertEquals((Object)confDir, (Object)builder.hadoopConfDir);
    }

    private File initConfDir(File confDir) throws Exception {
        confDir.mkdirs();
        new File(confDir, "core-site.xml").createNewFile();
        new File(confDir, "hdfs-site.xml").createNewFile();
        return confDir;
    }
}

