/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.concurrent.AcceptFunction;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FutureUtilsTest
extends TestLogger {
    @Parameterized.Parameter
    public FutureFactory futureFactory;

    @Parameterized.Parameters
    public static Collection<FutureFactory> parameters() {
        return Arrays.asList(new ConjunctFutureFactory(), new WaitingFutureFactory());
    }

    @Test
    public void testConjunctFutureFailsOnEmptyAndNull() throws Exception {
        try {
            this.futureFactory.createFuture(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.futureFactory.createFuture(Arrays.asList(new FlinkCompletableFuture(), null, new FlinkCompletableFuture()));
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testConjunctFutureCompletion() throws Exception {
        FlinkCompletableFuture future1 = new FlinkCompletableFuture();
        FlinkCompletableFuture future2 = new FlinkCompletableFuture();
        FlinkCompletableFuture future3 = new FlinkCompletableFuture();
        FlinkCompletableFuture future4 = new FlinkCompletableFuture();
        future2.complete(new Object());
        FutureUtils.ConjunctFuture<?> result = this.futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        Future resultMapped = result.thenAccept((AcceptFunction)new AcceptFunction<Object>(){

            public void accept(Object value) {
            }
        });
        Assert.assertEquals((long)4L, (long)result.getNumFuturesTotal());
        Assert.assertEquals((long)1L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future4.complete(new Object());
        Assert.assertEquals((long)2L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future1.complete(new Object());
        Assert.assertEquals((long)3L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future1.complete(new Object());
        Assert.assertEquals((long)3L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future3.complete(new Object());
        Assert.assertEquals((long)4L, (long)result.getNumFuturesCompleted());
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertTrue((boolean)resultMapped.isDone());
    }

    @Test
    public void testConjunctFutureFailureOnFirst() throws Exception {
        FlinkCompletableFuture future1 = new FlinkCompletableFuture();
        FlinkCompletableFuture future2 = new FlinkCompletableFuture();
        FlinkCompletableFuture future3 = new FlinkCompletableFuture();
        FlinkCompletableFuture future4 = new FlinkCompletableFuture();
        FutureUtils.ConjunctFuture<?> result = this.futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        Future resultMapped = result.thenAccept((AcceptFunction)new AcceptFunction<Object>(){

            public void accept(Object value) {
            }
        });
        Assert.assertEquals((long)4L, (long)result.getNumFuturesTotal());
        Assert.assertEquals((long)0L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future2.completeExceptionally((Throwable)new IOException());
        Assert.assertEquals((long)0L, (long)result.getNumFuturesCompleted());
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertTrue((boolean)resultMapped.isDone());
        try {
            result.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        try {
            resultMapped.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    @Test
    public void testConjunctFutureFailureOnSuccessive() throws Exception {
        FlinkCompletableFuture future1 = new FlinkCompletableFuture();
        FlinkCompletableFuture future2 = new FlinkCompletableFuture();
        FlinkCompletableFuture future3 = new FlinkCompletableFuture();
        FlinkCompletableFuture future4 = new FlinkCompletableFuture();
        FutureUtils.ConjunctFuture<?> result = this.futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        Assert.assertEquals((long)4L, (long)result.getNumFuturesTotal());
        Future resultMapped = result.thenAccept((AcceptFunction)new AcceptFunction<Object>(){

            public void accept(Object value) {
            }
        });
        future1.complete(new Object());
        future3.complete(new Object());
        future4.complete(new Object());
        future2.completeExceptionally((Throwable)new IOException());
        Assert.assertEquals((long)3L, (long)result.getNumFuturesCompleted());
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertTrue((boolean)resultMapped.isDone());
        try {
            result.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        try {
            resultMapped.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    @Test
    public void testConjunctFutureValue() throws ExecutionException, InterruptedException {
        FlinkCompletableFuture future1 = FlinkCompletableFuture.completed((Object)1);
        FlinkCompletableFuture future2 = FlinkCompletableFuture.completed((Object)2L);
        FlinkCompletableFuture future3 = new FlinkCompletableFuture();
        FutureUtils.ConjunctFuture result = FutureUtils.combineAll(Arrays.asList(future1, future2, future3));
        Assert.assertFalse((boolean)result.isDone());
        future3.complete((Object)0.1);
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertThat((Object)result.get(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Number[]{1, 2L, 0.1}));
    }

    @Test
    public void testConjunctOfNone() throws Exception {
        FutureUtils.ConjunctFuture<?> result = this.futureFactory.createFuture(Collections.emptyList());
        Assert.assertEquals((long)0L, (long)result.getNumFuturesTotal());
        Assert.assertEquals((long)0L, (long)result.getNumFuturesCompleted());
        Assert.assertTrue((boolean)result.isDone());
    }

    private static class WaitingFutureFactory
    implements FutureFactory {
        private WaitingFutureFactory() {
        }

        @Override
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends Future<?>> futures) {
            return FutureUtils.waitForAll(futures);
        }
    }

    private static class ConjunctFutureFactory
    implements FutureFactory {
        private ConjunctFutureFactory() {
        }

        @Override
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends Future<?>> futures) {
            return FutureUtils.combineAll(futures);
        }
    }

    private static interface FutureFactory {
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends Future<?>> var1);
    }
}

