/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.runtime.state.TaskStateHandles;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class TaskDeploymentDescriptorTest {
    @Test
    public void testSerialization() {
        try {
            JobID jobID = new JobID();
            JobVertexID vertexID = new JobVertexID();
            ExecutionAttemptID execId = new ExecutionAttemptID();
            AllocationID allocationId = new AllocationID();
            String jobName = "job name";
            String taskName = "task name";
            boolean numberOfKeyGroups = true;
            boolean indexInSubtaskGroup = false;
            boolean currentNumberOfSubtasks = true;
            boolean attemptNumber = false;
            Configuration jobConfiguration = new Configuration();
            Configuration taskConfiguration = new Configuration();
            Class<BatchTask> invokableClass = BatchTask.class;
            ArrayList producedResults = new ArrayList(0);
            ArrayList inputGates = new ArrayList(0);
            ArrayList requiredJars = new ArrayList(0);
            ArrayList requiredClasspaths = new ArrayList(0);
            SerializedValue executionConfig = new SerializedValue((Object)new ExecutionConfig());
            SerializedValue serializedJobInformation = new SerializedValue((Object)new JobInformation(jobID, "job name", executionConfig, jobConfiguration, requiredJars, requiredClasspaths));
            SerializedValue serializedJobVertexInformation = new SerializedValue((Object)new TaskInformation(vertexID, "task name", 1, 1, invokableClass.getName(), taskConfiguration));
            int targetSlotNumber = 47;
            TaskStateHandles taskStateHandles = new TaskStateHandles();
            TaskDeploymentDescriptor orig = new TaskDeploymentDescriptor(serializedJobInformation, serializedJobVertexInformation, execId, allocationId, 0, 0, 47, taskStateHandles, producedResults, inputGates);
            TaskDeploymentDescriptor copy = (TaskDeploymentDescriptor)CommonTestUtils.createCopySerializable((Serializable)orig);
            Assert.assertFalse((orig.getSerializedJobInformation() == copy.getSerializedJobInformation() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getSerializedTaskInformation() == copy.getSerializedTaskInformation() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getExecutionAttemptId() == copy.getExecutionAttemptId() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getTaskStateHandles() == copy.getTaskStateHandles() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getProducedPartitions() == copy.getProducedPartitions() ? 1 : 0) != 0);
            Assert.assertFalse((orig.getInputGates() == copy.getInputGates() ? 1 : 0) != 0);
            Assert.assertEquals((Object)orig.getSerializedJobInformation(), (Object)copy.getSerializedJobInformation());
            Assert.assertEquals((Object)orig.getSerializedTaskInformation(), (Object)copy.getSerializedTaskInformation());
            Assert.assertEquals((Object)orig.getExecutionAttemptId(), (Object)copy.getExecutionAttemptId());
            Assert.assertEquals((Object)orig.getAllocationId(), (Object)copy.getAllocationId());
            Assert.assertEquals((long)orig.getSubtaskIndex(), (long)copy.getSubtaskIndex());
            Assert.assertEquals((long)orig.getAttemptNumber(), (long)copy.getAttemptNumber());
            Assert.assertEquals((long)orig.getTargetSlotNumber(), (long)copy.getTargetSlotNumber());
            Assert.assertEquals((Object)orig.getTaskStateHandles(), (Object)copy.getTaskStateHandles());
            Assert.assertEquals((Object)orig.getProducedPartitions(), (Object)copy.getProducedPartitions());
            Assert.assertEquals((Object)orig.getInputGates(), (Object)copy.getInputGates());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

