/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobCache;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.OperatingSystem;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class BlobLibraryCacheManagerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLibraryCacheManagerCleanup() throws IOException, InterruptedException {
        JobID jid = new JobID();
        ArrayList<BlobKey> keys = new ArrayList<BlobKey>();
        BlobServer server = null;
        BlobLibraryCacheManager libraryCacheManager = null;
        byte[] buf = new byte[128];
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)new VoidBlobStore());
            InetSocketAddress blobSocketAddress = new InetSocketAddress(server.getPort());
            BlobClient bc = new BlobClient(blobSocketAddress, config);
            keys.add(bc.put(buf));
            buf[0] = (byte)(buf[0] + 1);
            keys.add(bc.put(buf));
            long cleanupInterval = 1000L;
            libraryCacheManager = new BlobLibraryCacheManager((BlobService)server, cleanupInterval);
            libraryCacheManager.registerJob(jid, keys, Collections.emptyList());
            ArrayList<File> files = new ArrayList<File>();
            for (BlobKey key : keys) {
                files.add(libraryCacheManager.getFile(key));
            }
            Assert.assertEquals((long)2L, (long)files.size());
            files.clear();
            libraryCacheManager.unregisterJob(jid);
            long deadline = System.currentTimeMillis() + 30000L;
            do {
                Thread.sleep(500L);
            } while (libraryCacheManager.getNumberOfCachedLibraries() > 0 && System.currentTimeMillis() < deadline);
            Assert.assertEquals((long)0L, (long)libraryCacheManager.getNumberOfCachedLibraries());
            int caughtExceptions = 0;
            for (BlobKey key : keys) {
                try {
                    files.add(libraryCacheManager.getFile(key));
                }
                catch (IOException ioe) {
                    ++caughtExceptions;
                }
            }
            Assert.assertEquals((long)2L, (long)caughtExceptions);
            bc.close();
        }
        finally {
            if (server != null) {
                server.close();
            }
            if (libraryCacheManager != null) {
                try {
                    libraryCacheManager.shutdown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterAndDownload() throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        BlobServer server = null;
        BlobCache cache = null;
        File cacheDir = null;
        try {
            Configuration config = new Configuration();
            server = new BlobServer(config, (BlobStore)new VoidBlobStore());
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            cache = new BlobCache(serverAddress, config, (BlobView)new VoidBlobStore());
            BlobClient uploader = new BlobClient(serverAddress, config);
            BlobKey dataKey1 = uploader.put(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
            BlobKey dataKey2 = uploader.put(new byte[]{11, 12, 13, 14, 15, 16, 17, 18});
            uploader.close();
            BlobLibraryCacheManager libCache = new BlobLibraryCacheManager((BlobService)cache, 1000000000L);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfCachedLibraries());
            try {
                libCache.getClassLoader(new JobID());
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            JobID jid = new JobID();
            ExecutionAttemptID executionId = new ExecutionAttemptID();
            Set<BlobKey> keys = Collections.singleton(dataKey1);
            libCache.registerTask(jid, executionId, keys, Collections.emptyList());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jid));
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfCachedLibraries());
            Assert.assertNotNull((Object)libCache.getClassLoader(jid));
            libCache.unregisterTask(jid, executionId);
            libCache.unregisterTask(jid, executionId);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jid));
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfCachedLibraries());
            try {
                libCache.getClassLoader(jid);
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            cacheDir = new File(cache.getStorageDir(), "cache");
            Assert.assertTrue((boolean)cacheDir.exists());
            Assert.assertTrue((String)"Could not remove write permissions from cache directory", (boolean)cacheDir.setWritable(false, false));
            try {
                libCache.registerTask(new JobID(), new ExecutionAttemptID(), Collections.singleton(dataKey2), Collections.emptyList());
                Assert.fail((String)"This should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (cacheDir != null && !cacheDir.setWritable(true, false)) {
                System.err.println("Could not re-add write permissions to cache directory.");
            }
            if (cache != null) {
                cache.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }
}

